<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT"/>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="COLLECT" type="CollectRecords">
	<DESCRIPTION>Start Harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="MD_BUILDER"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="MD_BUILDER"/>
	</ARCS>
</NODE>

<NODE name="MD_BUILDER" type="ApplyXslt" isJoin="true">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite','xslt')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
		<PARAM required="true" type="string" name="params" managedBy="system">{ 'datasourceId': '$params.("dataprovider:id")$' }</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE"/>
	</ARCS>
</NODE>

<NODE name="STORE" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
