package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.repohi.UpdateMetaWfStatusJobNode;

public class UpdateOpenaireMetaWfStatusJobNode extends UpdateMetaWfStatusJobNode {

	private ServiceLocator<DatasourceManagerService> datasourceManagerServiceLocator;

	@Override
	protected void updateDatasource(final String dsId, final String ifaceId) throws Exception {

		final String openaireDsId = getLookupLocator().getService().getResourceProfileByQuery(
				"/*[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']//FIELD/value[../key='OpenAireDataSourceId']/text()");

		if (openaireDsId.equals("openaire____::bootstrap")) {
			super.updateDatasource(dsId, ifaceId);
		} else {
			datasourceManagerServiceLocator.getService().updateActivationStatus(openaireDsId, ifaceId, true);
		}
	}

	public ServiceLocator<DatasourceManagerService> getDatasourceManagerServiceLocator() {
		return datasourceManagerServiceLocator;
	}

	@Required
	public void setDatasourceManagerServiceLocator(final ServiceLocator<DatasourceManagerService> datasourceManagerServiceLocator) {
		this.datasourceManagerServiceLocator = datasourceManagerServiceLocator;
	}

}
