package eu.dnetlib.msro.openaireplus.workflows.nodes.repobye;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.repobye.DeleteMetaWfJobNode;

public class DeleteOpenaireMetaWfJobNode extends DeleteMetaWfJobNode {

	private ServiceLocator<DatasourceManagerService> datasourceManagerServiceLocator;

	@Override
	protected void updateIfaceActivationStatus(final String dsId, final String ifaceId, final boolean active) throws Exception {

		final String openaireDsId = getLookupLocator().getService().getResourceProfileByQuery(
				"/*[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']//FIELD/value[../key='OpenAireDataSourceId']/text()");

		if (openaireDsId.equals("openaire____::bootstrap")) {
			super.updateIfaceActivationStatus(dsId, ifaceId, active);
		} else {
			datasourceManagerServiceLocator.getService().updateActivationStatus(openaireDsId, ifaceId, active);
		}
	}

	public ServiceLocator<DatasourceManagerService> getDatasourceManagerServiceLocator() {
		return datasourceManagerServiceLocator;
	}

	@Required
	public void setDatasourceManagerServiceLocator(final ServiceLocator<DatasourceManagerService> datasourceManagerServiceLocator) {
		this.datasourceManagerServiceLocator = datasourceManagerServiceLocator;
	}
}
