package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import java.io.File;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;

public class RepositoryNoURLIterator extends IteratorRepository {

	public RepositoryNoURLIterator(final Iterable<File> input, final String repositoryPrefix, final String oaiPrefix) {
		super(input, repositoryPrefix, oaiPrefix);
	}

	@Override
	String generateNextElement() {
		try {
			String inputname = input.next().getCanonicalPath();
			String[] values = inputname.split("/");
			if (values.length > 1) {
				ObjectStoreFile info = new ObjectStoreFile();
				String fileName = values[values.length - 1].replace(".xml", "");
				info.setAccessProtocol(Protocols.None);
				// String value = "oai:europepmc.org:" + fileName;
				String value = oaiPrefix + fileName;
				String resultID = repositoryPrefix + "::" + AbstractDNetOafXsltFunctions.md5(value);
				info.setObjectID(resultID);
				info.setMimeType("pdf");
				info.setURI(inputname);
				return info.toJSON();
			}
		} catch (Exception e) {
			return null;
		}
		return null;
	}

}
