package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.RunningJob;

import eu.dnetlib.msro.workflows.util.ProgressProvider;

public class MapreduceProgressProvider implements ProgressProvider {

	private static final Log log = LogFactory.getLog(MapreduceProgressProvider.class); // NOPMD by marko on 11/24/08 5:02 PM

	public static final int MAX_VALUE = 300;

	protected boolean inaccurate = false;

	protected RunningJob runningJob;

	public MapreduceProgressProvider(final RunningJob runningJob) {
		this.runningJob = runningJob;
	}

	@Override
	public int getTotalValue() {
		return MAX_VALUE;
	}

	@Override
	public int getCurrentValue() {
		try {
			return getIntValue();
		} catch (IOException e) {
			inaccurate = true;
			return 0;
		}
	}

	private int getIntValue() throws IOException {
		if (runningJob != null) {
			try {
				float value = runningJob.setupProgress() + runningJob.mapProgress() + runningJob.reduceProgress();
				return (int) value * 100;
			} catch (Throwable e) {
				log.warn("got exception getting job progress", e);
				return 0;
			}
		} else {
			throw new IOException("job handle not defined");
		}
	}

	@Override
	public boolean isInaccurate() {
		return inaccurate;
	}
}
