package eu.dnetlib.msro.openaireplus.workflows.nodes.dedup;

import javax.annotation.Resource;

import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Iterables;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;

public class DedupConfigurationLoader {

	@Resource
	private ServiceLocator<ISLookUpService> lookupLocator;
	
	private StringTemplate xqueryPace;
	
	private StringTemplate xqueryWf;
	
	public String loadPaceConf(String entityType) throws ISLookUpException {
		return loadConfig(getXquery(entityType, getXqueryPace()));
	}
	
	public String loadWfConf(String entityType) throws ISLookUpException {
		return loadConfig(getXquery(entityType, getXqueryWf()));
	}
	
	private String loadConfig(String xquery) throws ISLookUpException {
		return Iterables.getOnlyElement(lookupLocator.getService().quickSearchProfile(xquery));
	}

	////////////
	
    private String getXquery(String entityType, StringTemplate template) {
    	StringTemplate xquery = new StringTemplate(template.getTemplate());
    	xquery.setAttribute("entityType", entityType);
        return xquery.toString();
    }	
	
	public StringTemplate getXqueryPace() {
		return xqueryPace;
	}

	@Required
	public void setXqueryPace(StringTemplate xqueryPace) {
		this.xqueryPace = xqueryPace;
	}

	public StringTemplate getXqueryWf() {
		return xqueryWf;
	}

	@Required
	public void setXqueryWf(StringTemplate xqueryWf) {
		this.xqueryWf = xqueryWf;
	}
}
