package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindExistingRepositoriesJobNode extends SimpleJobNode {
	
	@Resource(name="lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String existingReposParam = "existingRepos";
	
	class RepositoryInfo {
		public String resourceKind;
		public String repoId;

		public RepositoryInfo(String resourceKind, String repoId) {
			this.resourceKind = resourceKind;
			this.repoId = repoId;
		}
		@Override
		public String toString() {
			return "[" + resourceKind + ", " + repoId + "]";
		}
	}

	@Override
	protected String execute(NodeToken token) throws Exception {
		String xquery = 
				"for $x in /*[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType'] " +
				"return concat (" +
				"$x//RESOURCE_IDENTIFIER/@value, " +
				"'@@@', " +
				"$x//RESOURCE_KIND/@value, " +
				"'@@@', " +
				"$x//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value)";
		final List<String> list = lookupLocator.getService().quickSearchProfile(xquery);
		
		final Map<String, RepositoryInfo> map = Maps.newHashMap();
		for (String s : list) {
			String[] arr = s.split("@@@");
			if (arr.length == 3) {
				map.put(arr[2], new RepositoryInfo(arr[1], arr[0]));
			}
		}
		token.getEnv().setTransientAttribute(getExistingReposParam(), map);
		
		return Arc.DEFAULT_ARC;
	}

	public String getExistingReposParam() {
		return existingReposParam;
	}

	public void setExistingReposParam(String existingReposParam) {
		this.existingReposParam = existingReposParam;
	}

}
