<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">
	
		<xsl:variable name="projectId" select="dnet:oafSplitId('project', //FIELD[@name = 'project'])" />
		<xsl:variable name="contactpersonId" select="dnet:oafSplitId('person', //FIELD[@name = 'contactperson'])" />

		<ROWS>
			<xsl:if test="string-length($projectId) &gt; 0 and string-length($contactpersonId) &gt; 0">
			
				<xsl:variable name="projectcontactperson" 
						select="dnet:oafRel('projectContactperson', $projectId, $contactpersonId, //FIELD[not(@isNull)])"/>
				<xsl:variable name="contactpersonproject" 
						select="dnet:oafRel('projectContactperson', $contactpersonId, $projectId, //FIELD[not(@isNull)])"/>											
			
				<ROW key="{$projectId}" columnFamily="projectContactperson">
					<QUALIFIER name="{$contactpersonId}" type="base64"><xsl:value-of select="$projectcontactperson"/></QUALIFIER>
				</ROW>
				<ROW key="{$contactpersonId}" columnFamily="projectContactperson">
					<QUALIFIER name="{$projectId}" type="base64"><xsl:value-of select="$contactpersonproject"/></QUALIFIER>
				</ROW>
			</xsl:if>
		</ROWS>
	
	</xsl:template>

</xsl:stylesheet>
