<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">
	
		<xsl:variable name="datasourceId" select="dnet:oafSplitId('datasource', //FIELD[@name = 'datasource'])" />
		<xsl:variable name="organizationId" select="dnet:oafSplitId('organization', //FIELD[@name = 'organization'])" />

		<ROWS>
			<xsl:if test="string-length($datasourceId) &gt; 0 and string-length($organizationId) &gt; 0">

				<xsl:variable name="datasourceorganization" select="dnet:oafRel('datasourceOrganization', $datasourceId, $organizationId, //FIELD[not(@isNull)])"/>
				<xsl:variable name="organizationdatasource" select="dnet:oafRel('datasourceOrganization', $organizationId, $datasourceId, //FIELD[not(@isNull)])"/>

				<ROW key="{$datasourceId}" columnFamily="datasourceOrganization">
					<QUALIFIER name="{$organizationId}" type="base64"><xsl:value-of select="$datasourceorganization"/></QUALIFIER>
				</ROW>
				<ROW key="{$organizationId}" columnFamily="datasourceOrganization">
					<QUALIFIER name="{$datasourceId}" type="base64"><xsl:value-of select="$organizationdatasource"/></QUALIFIER>
				</ROW>
			</xsl:if>			
		</ROWS>
	
	</xsl:template>

</xsl:stylesheet>
