<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dnet="eu.dnetlib.enabling.datasources.DatasourceFunctions"
	exclude-result-prefixes="xsl dnet">

	<xsl:template match="/">
	
		<RESOURCE_PROFILE>
			<HEADER>
				<RESOURCE_IDENTIFIER value="" />
				<RESOURCE_TYPE value="RepositoryServiceResourceType" />
				<RESOURCE_KIND value="RepositoryServiceResources" />
				<RESOURCE_URI value="" />
				<DATE_OF_CREATION value="" />
				<PROTOCOL />
			</HEADER>
			<BODY>
				<CONFIGURATION>
		            <DATASOURCE_TYPE>
		            	<xsl:value-of select="//FIELD[@name='datasourceclass']" />
		            </DATASOURCE_TYPE>
            		<DATASOURCE_ORIGINAL_ID provenance="OPENAIRE">
            			<xsl:value-of select="//FIELD[@name='id']" />
            		</DATASOURCE_ORIGINAL_ID>
            		<DATASOURCE_AGGREGATED>false</DATASOURCE_AGGREGATED>
            		<ENVIRONMENTS>
                		<ENVIRONMENT>OPENAIRE</ENVIRONMENT>
            		</ENVIRONMENTS>
				
					<TYPOLOGY><xsl:value-of select="//FIELD[@name='typology']" /></TYPOLOGY>
					<MAX_SIZE_OF_DATASTRUCTURE>0</MAX_SIZE_OF_DATASTRUCTURE>
					<AVAILABLE_DISKSPACE>0</AVAILABLE_DISKSPACE>
					<MAX_NUMBER_OF_DATASTRUCTURE>0</MAX_NUMBER_OF_DATASTRUCTURE>
					<OFFICIAL_NAME>
						<xsl:value-of select="//FIELD[@name='officialname']" />
					</OFFICIAL_NAME>
					<ENGLISH_NAME>
						<xsl:choose>
							<xsl:when
								test="//FIELD[@name='englishname' and (@isNull='true' or string-length(normalize-space(.)) = 0)]">
								<xsl:value-of select="//FIELD[@name='officialname']" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//FIELD[@name='englishname']" />
							</xsl:otherwise>
						</xsl:choose>
					</ENGLISH_NAME>
					<ICON_URI>
						<xsl:value-of select="//FIELD[@name='logourl']" />
					</ICON_URI>
					<COUNTRY>
						<xsl:value-of select="//FIELD[@name='countrycode']" />
					</COUNTRY>
					<LOCATION>
						<LONGITUDE>
							<xsl:choose>
								<xsl:when test="//FIELD[@name='longitude' and @isNull='true']">
									0.0
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//FIELD[@name='longitude']" />
								</xsl:otherwise>
							</xsl:choose>
						</LONGITUDE>
						<LATITUDE>
							<xsl:choose>
								<xsl:when test="//FIELD[@name='latitude' and @isNull='true']">
									0.0
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//FIELD[@name='latitude']" />
								</xsl:otherwise>
							</xsl:choose>
						</LATITUDE>
						<TIMEZONE>0.0</TIMEZONE>
					</LOCATION>
					<REPOSITORY_WEBPAGE>
						<xsl:value-of select="//FIELD[@name='websiteurl']" />
					</REPOSITORY_WEBPAGE>
					<REPOSITORY_INSTITUTION>
						<xsl:value-of select="//FIELD[@name='organization']" />
					</REPOSITORY_INSTITUTION>
					<ADMIN_INFO>
						<xsl:value-of select="//FIELD[@name='contactemail']" />
					</ADMIN_INFO>
					<INTERFACES>
					<xsl:for-each select="//FIELD[@name='accessinfopackage']/ITEM">
						<xsl:value-of select="dnet:buildInterface(.)" disable-output-escaping="yes"/>
					</xsl:for-each>
					</INTERFACES>
					<EXTRA_FIELDS>
						<FIELD>
							<key>OpenAireDataSourceId</key>
							<value>
								<xsl:value-of select="//FIELD[@name='id']" />
							</value>
						</FIELD>
						<FIELD>
							<key>NamespacePrefix</key>
							<value>
								<xsl:value-of select="//FIELD[@name='namespaceprefix']" />
							</value>
						</FIELD>
						<FIELD>
							<key>VERIFIED</key>
							<value>NO</value>
						</FIELD>
						<FIELD>
							<key>aggregatorName</key>
							<value><xsl:value-of select="//FIELD[@name='aggregator']" /></value>
						</FIELD>
						<FIELD>
							<key>dateOfValidation</key>
							<value>
								<xsl:value-of select="//FIELD[@name='dateofvalidation']"/>
							</value>
						</FIELD>
						<FIELD>
							<key>dateOfCollection</key>
							<value>
								<xsl:value-of select="//FIELD[@name='dateofcollection']"/>
							</value>
						</FIELD>
						
						<FIELD>
							<key>mergeHomonyms</key>
							<value>
								<xsl:value-of select="//FIELD[@name='mergehomonyms']"/>
							</value>
						</FIELD>
						
						<xsl:if test="string-length(normalize-space(//FIELD[@name='activationid'])) &gt; 0">
							<FIELD>
								<key>ACTID</key>
								<value>
									<xsl:value-of select="//FIELD[@name='activationid']"/>
								</value>
							</FIELD>
						</xsl:if>					
					</EXTRA_FIELDS>
					<REGISTERED_BY><xsl:value-of select="//FIELD[@name='registeredby']"/></REGISTERED_BY>
				</CONFIGURATION>
				<STATUS>
					<NUMBER_OF_OBJECTS>
						<xsl:choose>
							<xsl:when test="//FIELD[@name='od_numberofitems' and @isNull='true']">
								0
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//FIELD[@name='od_numberofitems']" />
							</xsl:otherwise>
						</xsl:choose>
					</NUMBER_OF_OBJECTS>
					<LAST_UPDATE value="{//FIELD[@name='now']}"/>
				</STATUS>
				<QOS>
					<AVAILABILITY>0</AVAILABILITY>
					<CAPACITY/>
					<THROUGHPUT>0.0</THROUGHPUT>
				</QOS>
				<SECURITY_PARAMETERS />
				<BLACKBOARD />
			</BODY>
		</RESOURCE_PROFILE>
	</xsl:template>
</xsl:stylesheet>
