package eu.dnetlib.data.information.oai.publisher.info;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

import com.google.common.collect.Sets;

public class RecordInfo {

	private String prefix = "";
	private String identifier = "";
	private Date datestamp = null;
	private Set<String> setspecs = Sets.newHashSet();
	private String metadata = "";
	private String internalId = "";
	private boolean deleted;

	public RecordInfo() {}

	public RecordInfo(final String prefix, final String identifier, final Date datestamp, final String setspec, final String metadata, final boolean deleted) {
		this(prefix, identifier, datestamp, Sets.newHashSet(setspec), metadata, deleted);
	}

	public RecordInfo(final String prefix, final String identifier, final Date datestamp, final Set<String> setspecs, final String metadata,
			final boolean deleted) {
		super();
		this.prefix = prefix;
		this.identifier = identifier;
		this.datestamp = datestamp;
		this.setspecs = setspecs;
		this.metadata = metadata;
		this.deleted = deleted;
	}

	public boolean addSetspec(final String setspec) {
		if (!setspecs.contains(setspec)) {
			setspecs.add(setspec);
			return true;
		} else return false;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(final String prefix) {
		this.prefix = prefix;
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(final String identifier) {
		this.identifier = identifier;
	}

	public Date getDatestamp() {
		return datestamp;
	}

	public void setDatestamp(final Date datestamp) {
		this.datestamp = datestamp;
	}

	public Set<String> getSetspecs() {
		return setspecs;
	}

	public void setSetspecs(final Set<String> setspecs) {
		this.setspecs = setspecs;
	}

	public String getMetadata() {
		return metadata;
	}

	public void setMetadata(final String metadata) {
		this.metadata = metadata;
	}

	/**
	 * 
	 * @return the date formatted in ISO8601, UTC with format YYYY-MM-DDThh:mm:ssZ, where Z is the time zone.
	 */
	public String getNormalizedDatestamp() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
		formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
		String date = formatter.format(datestamp);
		return date.replace("+0000", "Z");
	}

	public String getInternalId() {
		return internalId;
	}

	public void setInternalId(final String internalId) {
		this.internalId = internalId;
	}

	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted(final boolean deleted) {
		this.deleted = deleted;
	}

}
