package eu.dnetlib.data.information.oai.publisher.conf;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.PublisherField;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;

/**
 * Instances of this class read the configuration of the OAI publisher from the IS, by performing xquery on the Exist database.
 * 
 * @author alessia
 * 
 */
public class OAIConfigurationExistReader extends AbstractOAIConfigurationReader {

	@Resource
	private SplittedQueryExecutor queryExecutor;

	@Override
	public List<SetInfo> getSets() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
		Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
		return Lists.newArrayList(sets);
	}

	@Override
	public List<SetInfo> getSets(final boolean onlyEnabled) {
		if (onlyEnabled) {
			final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
					+ "where $x/@enabled/string() = 'true' "
					+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
			Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
			return Lists.newArrayList(sets);
		} else return this.getSets();
	}

	@Override
	public List<String> getSetSpecs() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "return $x/spec/string() ";
		List<String> names = this.queryExecutor.performQuery(query);
		return names;
	}

	@Override
	public List<String> getSetSpecs(final boolean onlyEnabled) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "where $x/@enabled/string() = '" + onlyEnabled + "' " + "return $x/spec/string() ";
		List<String> names = this.queryExecutor.performQuery(query);
		return names;
	}

	@Override
	public SetInfo getSetInfo(final String setSpec) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "where $x/spec = '"
				+ setSpec
				+ "' "
				+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
		Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
		if (sets.iterator().hasNext()) return sets.iterator().next();
		else return null;
	}

	@Override
	public List<MDFInfo> getSourceMetadataFormats() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
				+ "return concat($x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string())";

		List<String> res;
		try {
			res = this.queryExecutor.getLookupLocator().getService().quickSearchProfile(query);
		} catch (ISLookUpException e) {
			throw new OaiPublisherRuntimeException(e);
		}
		Set<MDFInfo> sources = Sets.newHashSet();
		for (String src : res) {
			String[] splitted = src.split(":-:");
			MDFInfo mdfInfo = new MDFInfo();
			mdfInfo.setSourceFormatName(splitted[0]);
			mdfInfo.setSourceFormatLayout(splitted[1]);
			mdfInfo.setSourceFormatInterpretation(splitted[2]);
			sources.add(mdfInfo);
		}
		return Lists.newArrayList(sources);
	}

	@Override
	public List<MDFInfo> getMetadataFormatInfo() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
				+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
				+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
				+ "':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
		Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
		return Lists.newArrayList(mdFormats);
	}

	@Override
	public List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled) {
		if (onlyEnabled) {
			final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
					+ "where $x/@exportable/string() = 'true' "
					+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
					+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
					+ "':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
			Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
			return Lists.newArrayList(mdFormats);
		} else return getMetadataFormatInfo();
	}

	@Override
	public MDFInfo getMetadataFormatInfo(final String mdPrefix) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
				+ "where $x/@metadataPrefix/string()='"
				+ mdPrefix
				+ "' "
				+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
				+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
				+ "':-:', $x//BASE_QUERY,':-:', $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
		Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
		Iterator<MDFInfo> iterator = mdFormats.iterator();
		if (iterator.hasNext()) return iterator.next();
		else return null;
	}

	@Override
	public List<PublisherField> getFields() {
		throw new UnimplementedException();
	}

	@Override
	public List<PublisherField> getFields(final String format, final String interpretation, final String layout) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//INDICES/INDEX "
				+ "return concat($x/@name, ':-:', $x/@repeatable, ':-:', string-join($x/SOURCE[@name='"
				+ format
				+ "' and @interpretation='"
				+ interpretation
				+ "' and @layout='" + layout + "']/@path, ':-:'))";
		List<String> res;
		try {
			res = this.queryExecutor.getLookupLocator().getService().quickSearchProfile(query);
		} catch (ISLookUpException e) {
			throw new OaiPublisherRuntimeException(e);
		}
		List<PublisherField> fields = Lists.newArrayList();
		for (String index : res) {
			String[] splitted = index.split(":-:");
			String indexName = splitted[0];
			String repeatable = splitted[1];
			PublisherField field = new PublisherField();
			field.setFieldName(indexName);
			field.setRepeatable(Boolean.valueOf(repeatable));
			Multimap<String, String> sources = ArrayListMultimap.create();
			String mdFormat = format + "-" + layout + "-" + interpretation;
			for (int i = 2; i < splitted.length; i++) {
				sources.put(mdFormat, splitted[i]);
			}
			field.setSources(sources);
			fields.add(field);
		}
		return fields;
	}

	@Override
	public List<String> getFieldNames() {
		String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDICES/INDEX/@name/string()";
		try {
			return this.queryExecutor.getLookupLocator().getService().quickSearchProfile(query);
		} catch (ISLookUpException e) {
			throw new OaiPublisherRuntimeException(e);
		}
	}

	public SplittedQueryExecutor getQueryExecutor() {
		return queryExecutor;
	}

	public void setQueryExecutor(final SplittedQueryExecutor queryExecutor) {
		this.queryExecutor = queryExecutor;
	}

}
