/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.info;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.ResumptionToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ResumptionTokenImpl
implements ResumptionToken {
    private int nMaxElements;
    private String metadataPrefix;
    private String query;
    private int nRead;
    private String lastObjIdentifier;
    private String requestedSet = "";

    @Override
    public String serialize() {
        String escapedQuery = StringEscapeUtils.escapeXml((String)this.query);
        ArrayList info = Lists.newArrayList((Object[])new String[]{"" + this.nMaxElements, this.metadataPrefix, escapedQuery, "" + this.nRead, this.lastObjIdentifier, this.requestedSet});
        try {
            String encoded = URLEncoder.encode(StringUtils.join((Collection)info, (String)"|"), "UTF-8");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new OaiPublisherRuntimeException(e);
        }
    }

    @Override
    public void deserialize(String token) {
        String unescapedQuery;
        String decoded;
        try {
            decoded = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OaiPublisherRuntimeException(e);
        }
        String[] info = StringUtils.split((String)decoded, (String)"|");
        if (info.length < 5) {
            throw new OaiPublisherRuntimeException("badResumptionToken");
        }
        this.nMaxElements = Integer.parseInt(info[0]);
        this.metadataPrefix = info[1];
        this.query = unescapedQuery = StringEscapeUtils.unescapeXml((String)info[2]);
        this.nRead = Integer.parseInt(info[3]);
        this.lastObjIdentifier = info[4];
        if (info.length == 6) {
            this.requestedSet = info[5];
        }
    }

    @Override
    public int getnMaxElements() {
        return this.nMaxElements;
    }

    @Override
    public void setnMaxElements(int nMaxElements) {
        this.nMaxElements = nMaxElements;
    }

    @Override
    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    @Override
    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public int getnRead() {
        return this.nRead;
    }

    @Override
    public void setnRead(int nRead) {
        this.nRead = nRead;
    }

    @Override
    public String getLastObjIdentifier() {
        return this.lastObjIdentifier;
    }

    @Override
    public void setLastObjIdentifier(String lastObjIdentifier) {
        this.lastObjIdentifier = lastObjIdentifier;
    }

    @Override
    public String getRequestedSet() {
        return this.requestedSet;
    }

    @Override
    public void setRequestedSet(String requestedSet) {
        this.requestedSet = requestedSet;
    }

    public String toString() {
        return "ResumptionToken [nMaxElements=" + this.nMaxElements + ", metadataPrefix=" + this.metadataPrefix + ", query=" + this.query + ", nRead=" + this.nRead + ", lastObjIdentifier=" + this.lastObjIdentifier + ", requestedSet= " + this.requestedSet + "]";
    }
}

