/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.info;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;

public class RecordInfo {
    private String prefix = "";
    private String identifier = "";
    private Date datestamp = null;
    private List<String> setspecs = Lists.newArrayList();
    private String metadata = "";
    private String internalId = "";
    private boolean deleted;

    public RecordInfo() {
    }

    public RecordInfo(String prefix, String identifier, Date datestamp, String setspec, String metadata, boolean deleted) {
        this(prefix, identifier, datestamp, Lists.newArrayList((Object[])new String[]{setspec}), metadata, deleted);
    }

    public RecordInfo(String prefix, String identifier, Date datestamp, List<String> setspecs, String metadata, boolean deleted) {
        this.prefix = prefix;
        this.identifier = identifier;
        this.datestamp = datestamp;
        this.setspecs = setspecs;
        this.metadata = metadata;
        this.deleted = deleted;
    }

    public boolean addSetspec(String setspec) {
        if (!this.setspecs.contains(setspec)) {
            this.setspecs.add(setspec);
            return true;
        }
        return false;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Date getDatestamp() {
        return this.datestamp;
    }

    public void setDatestamp(Date datestamp) {
        this.datestamp = datestamp;
    }

    public List<String> getSetspecs() {
        return this.setspecs;
    }

    public void setSetspecs(List<String> setspecs) {
        this.setspecs = setspecs;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getNormalizedDatestamp() {
        return DateFormatUtils.ISO_DATETIME_FORMAT.format(this.datestamp) + 'z';
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

