/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import eu.dnetlib.data.information.oai.publisher.conf.PublisherConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublisherConfigurationWriter {
    private static final Log log = LogFactory.getLog(PublisherConfigurationWriter.class);
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;
    @Resource
    private PublisherConfigurationReader configuration;

    public boolean updateMetadataFormat(String mdPrefix, MDFInfo newInfo) throws ISRegistryException {
        String xUpdate = "update replace //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION//METADATAFORMAT[./@metadataPrefix/string()='" + mdPrefix + "'] with <METADATAFORMAT exportable=\"" + newInfo.isEnabled() + "\" metadataPrefix=\"" + newInfo.getPrefix() + "\">" + "<NAMESPACE>" + newInfo.getNamespace() + "</NAMESPACE><SCHEMA>" + newInfo.getSchema() + "</SCHEMA><SOURCE_METADATA_FORMAT interpretation=\"" + newInfo.getSourceFormatInterpretation() + "\" layout=\"" + newInfo.getSourceFormatLayout() + "\" name=\"" + newInfo.getSourceFormatName() + "\"/><TRANSFORMATION_RULE>" + newInfo.getTransformationRuleID() + "</TRANSFORMATION_RULE><BASE_QUERY>" + newInfo.getBaseQuery() + "</BASE_QUERY></METADATAFORMAT>";
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean addMetadataFormat(MDFInfo newInfo) throws ISRegistryException {
        String action = "update insert ";
        String newNode = "<METADATAFORMAT metadataPrefix='" + newInfo.getPrefix() + "' exportable='" + newInfo.isEnabled() + "' ><NAMESPACE>" + newInfo.getNamespace() + "</NAMESPACE><SCHEMA>" + newInfo.getSchema() + "</SCHEMA>" + "<SOURCE_METADATA_FORMAT interpretation='" + newInfo.getSourceFormatInterpretation() + "' layout='" + newInfo.getSourceFormatLayout() + "' name='" + newInfo.getSourceFormatName() + "' /><TRANSFORMATION_RULE>" + newInfo.getTransformationRuleID() + "</TRANSFORMATION_RULE><BASE_QUERY>" + newInfo.getBaseQuery() + "</BASE_QUERY></METADATAFORMAT>";
        String targetNode = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION/METADATAFORMATS";
        String xUpdate = action + newNode + " into " + targetNode;
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean deleteMetadataFormat(String mdPrefix) throws ISRegistryException {
        String xUpdate = "update delete //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION//METADATAFORMATS/METADATAFORMAT[./@metadataPrefix/string()='" + mdPrefix + "']";
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean updateOAISet(String setSpec, SetInfo newInfo) throws ISRegistryException {
        String xUpdate = "update replace //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION//OAISET[spec/text()='" + setSpec + "'] with " + "<OAISET enabled=\"" + newInfo.isEnabled() + "\">" + "<spec>" + newInfo.getSetSpec() + "</spec>" + "<name>" + newInfo.getSetName() + "</name>" + "<description>" + newInfo.getSetDescription() + "</description>" + "<query>" + newInfo.getQuery() + "</query></OAISET>";
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean addOAISet(SetInfo newInfo) throws ISRegistryException {
        String action = "update insert ";
        String newNode = "<OAISET enabled=\"" + newInfo.isEnabled() + "\">" + "<spec>" + newInfo.getSetSpec() + "</spec>" + "<name>" + newInfo.getSetName() + "</name>" + "<description>" + newInfo.getSetDescription() + "</description>" + "<query>" + newInfo.getQuery() + "</query></OAISET>";
        String targetNode = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION/OAISETS";
        String xUpdate = action + newNode + " into " + targetNode;
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean deleteOAISet(String setSpec) throws ISRegistryException {
        String xUpdate = "update delete //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION//OAISET[spec/text()='" + setSpec + "']";
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean updateIndices(String format, String layout, String interpretation, Map<String, List<String>> indexes) throws ISRegistryException {
        boolean dropped = this.dropIndexesFor(format, layout, interpretation);
        String xUpdateAction = "update insert ";
        String nodeTemplate = " <SOURCE name='" + format + "' layout='" + layout + "' interpretation='" + interpretation + "' ";
        String targetTemplate = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION/INDICES/INDEX";
        if (!dropped) {
            return false;
        }
        for (String indexName : indexes.keySet()) {
            String targetNode = targetTemplate + "[@name='" + indexName + "']";
            List<String> paths = indexes.get(indexName);
            for (String p : paths) {
                String node = nodeTemplate + " path=\"" + p + "\" />";
                String xUpdate = xUpdateAction + node + " into " + targetNode;
                log.info((Object)("TO RUN: \n" + xUpdate));
                boolean done = ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
                if (done) continue;
                return false;
            }
        }
        return true;
    }

    private boolean dropIndexesFor(String format, String layout, String interpretation) throws ISRegistryException {
        String xUpdate = "update delete //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDEX/SOURCE[./@interpretation/string()='" + interpretation + "' and ./@name/string()='" + format + "' and ./@layout/string()='" + layout + "'] ";
        return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
    }

    public boolean addNewIndex(String format, String layout, String interpretation, String indexName, String[] paths) throws ISLookUpException, ISRegistryException {
        String action = "update insert ";
        String nodeTemplate = " <SOURCE name='" + format + "' layout='" + layout + "' interpretation='" + interpretation + "' ";
        String targetTemplate = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']//CONFIGURATION/INDICES";
        if (this.configuration.getIndexNames().contains(indexName)) {
            String targetNode = targetTemplate + "/INDEX[@name/string()='" + indexName + "']";
            for (String p : paths) {
                String node = nodeTemplate + " path=\"" + p + "\" />";
                String xUpdate = action + node + " into " + targetNode;
                log.info((Object)("TO RUN: \n" + xUpdate));
                boolean done = ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
                if (done) continue;
                return false;
            }
        } else {
            String targetNode = targetTemplate;
            String node = "<INDEX name='" + indexName + "'>";
            for (String p : paths) {
                node = node + nodeTemplate + " path=\"" + p + "\" />";
            }
            node = node + "</INDEX>";
            String xUpdate = action + node + " into " + targetNode;
            log.info((Object)("TO RUN: \n" + xUpdate));
            boolean done = ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xUpdate);
            if (!done) {
                return false;
            }
        }
        return true;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public PublisherConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PublisherConfigurationReader configuration) {
        this.configuration = configuration;
    }
}

