package eu.dnetlib.oai.init.hdfs;

import javax.annotation.Resource;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.sync.OAIStoreInitializer;
import eu.dnetlib.data.oai.store.sync.OAIStoreInitializerFactory;

public class HDFSOAIInitializerFactory extends OAIStoreInitializerFactory {

	private Path filePath;
	@Resource
	private ConfigurationEnumerator configurationEnumerator;

	private int limitRead = -1;

	@Override
	public OAIStoreInitializer create(final MDFInfo mdfInfo, final boolean forceContentSyncronization) {
		Configuration conf = configurationEnumerator.get(ClusterName.DM);
		return new PublisherInitializerHDFS(mdfInfo, getPublisherStoreDAO(), forceContentSyncronization, filePath, conf, limitRead);
	}

	public Path getFilePath() {
		return filePath;
	}

	@Required
	public void setFilePath(final Path filePath) {
		this.filePath = filePath;
	}

	public int getLimitRead() {
		return limitRead;
	}

	public void setLimitRead(final int limitRead) {
		this.limitRead = limitRead;
	}

}
