/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.init.hdfs;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.hadoop.hdfs.SequenceFileUtils;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizer;
import eu.dnetlib.miscutils.collections.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class PublisherInitializerHDFS
extends OAIStoreContentSynchronizer {
    private static final Log log = LogFactory.getLog(PublisherInitializerHDFS.class);
    private Path path;
    private Configuration conf;
    private int limitRead = -1;

    protected void synchronizeContent(MongoPublisherStore store) {
        log.info((Object)("Synchronizing content for stores: \n\tformat:" + this.getMdfInfo().getSourceFormatName() + " \n\tinterpretation: " + this.getMdfInfo().getSourceFormatInterpretation() + " \n\tlayout: " + this.getMdfInfo().getSourceFormatLayout()));
        try {
            Iterable records = SequenceFileUtils.read((Path)this.path, (Configuration)this.conf, (int)this.limitRead);
            Iterable recordsIterable = Iterables.transform((Iterable)records, (Function)new Function<Pair<Text, Text>, String>(){

                public String apply(Pair<Text, Text> pair) {
                    return ((Text)pair.getValue()).toString();
                }
            });
            store.feed(recordsIterable, "");
        }
        catch (Exception e) {
            log.fatal((Object)("Can't synchronize content for stores: \n\tformat:" + this.getMdfInfo().getSourceFormatName() + " \n\tinterpretation: " + this.getMdfInfo().getSourceFormatInterpretation() + " \n\tlayout: " + this.getMdfInfo().getSourceFormatLayout()));
            log.fatal((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public PublisherInitializerHDFS() {
    }

    public PublisherInitializerHDFS(MDFInfo mdfInfo, MongoPublisherStoreDAO oaiStoreDao, Path path, Configuration conf) {
        this(mdfInfo, oaiStoreDao, path, conf, -1);
    }

    public PublisherInitializerHDFS(MDFInfo mdfInfo, MongoPublisherStoreDAO oaiStoreDao, Path path, Configuration conf, int limitRead) {
        super(mdfInfo, oaiStoreDao);
        this.path = path;
        this.conf = conf;
        this.limitRead = limitRead;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int getLimitRead() {
        return this.limitRead;
    }

    public void setLimitRead(int limitRead) {
        this.limitRead = limitRead;
    }
}

