/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.init.hdfs;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizer;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizerFactory;
import eu.dnetlib.oai.init.hdfs.PublisherInitializerHDFS;
import javax.annotation.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Required;

public class HDFSOAIInitializerFactory
extends OAIStoreContentSynchronizerFactory {
    private Path filePath;
    @Resource
    private ConfigurationEnumerator configurationEnumerator;
    private int limitRead = -1;

    public OAIStoreContentSynchronizer create(MDFInfo mdfInfo) {
        Configuration conf = this.configurationEnumerator.get(ClusterName.DM);
        return new PublisherInitializerHDFS(mdfInfo, this.getPublisherStoreDAO(), this.filePath, conf, this.limitRead);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Required
    public void setFilePath(Path filePath) {
        this.filePath = filePath;
    }

    public int getLimitRead() {
        return this.limitRead;
    }

    public void setLimitRead(int limitRead) {
        this.limitRead = limitRead;
    }
}

