<form class="form-horizontal">
	<fieldset>
		<legend>Metadata Format: {{currentMdf.prefix}}</legend>
		<div class="control-group">
			<label class="control-label" for="enabled">Enabled</label>
			<div class="controls">
				<input type="checkbox" ng-model="currentMdf.enabled" id="enabled" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="prefix">Prefix</label>
			<div class="controls">
				<input ng-model="currentMdf.prefix" required id="prefix" type="text" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="schema">Schema</label>
			<div class="controls">
				<input class="input-xxlarge" ng-model="currentMdf.schema" required
					id="schema" type="text" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="namespace">Namespace</label>
			<div class="controls">
				<input class="input-xxlarge" ng-model="currentMdf.namespace"
					required id="namespace" type="text" />
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">Source Format</label>
			<div class="controls">
				<div class="input-prepend">
					<span class="add-on">Name:</span> <input
						ng-model="currentMdf.sourceFormatName" required placeholder="name"
						type="text" />
				</div>
				<div class="input-prepend">
					<span class="add-on">Layout:</span> <input
						ng-model="currentMdf.sourceFormatLayout" required
						placeholder="layout" type="text" />
				</div>
				<div class="input-prepend">
					<span class="add-on">Interpretation:</span> <input
						ng-model="currentMdf.sourceFormatInterpretation" required
						placeholder="interpretation" type="text" />
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="query">Base query</label>
			<div class="controls">
				<input class="input-xxlarge" ng-model="currentMdf.baseQuery"
					id="query" type="text" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="tds">Transformation Rule</label>
			<div class="controls">
				<span id="tds"> <select
					ng-model="currentMdf.transformationRuleID">
					<option value="" ng-selected="equals(currentMdf.transformationRuleID,'')">-- no rule --</option>
					<option ng-repeat="rule in tdsRules" value="{{rule.id}}" ng-selected="equals(rule.id,currentMdf.transformationRuleID)">{{rule.title}}</option>
				</select>
				</span>
			</div>
		</div>

		<div class="control-group">
			<div class="controls">
				<button class="btn btn-large btn-success"
					ng-click="saveExportMetadataFormat(currentPrefix, currentMdf)"
					tooltip rel="tooltip" data-placement="left" title="Save changes">
					<i class="icon-white icon-ok"></i>
				</button>
				<button class="btn btn-large btn-info"
					ng-click="loadExportMetadataFormat(currentPrefix)" tooltip
					rel="tooltip" data-placement="bottom" title="Discard changes">
					<i class="icon-white icon-repeat"></i>
				</button>
				<button class="btn btn-large btn-danger"
					ng-click="deleteExportMetadataFormat(currentPrefix)" tooltip
					rel="tooltip" data-placement="right" title="Delete format">
					<i class="icon-white icon-remove"></i>
				</button>
			</div>
		</div>
	</fieldset>
</form>
<hr>