package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;

public class SyncOAIStoreJobNode extends BlackboardJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String eprParam;

	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	private ResultsetProgressProvider progressProvider;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='OAIStoreServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {
		log.fatal("I am in " + this.getClass() + " method prepareJob");
		job.setAction("SYNC");
		final String eprS = token.getEnv().getAttribute(getEprParam());
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
		job.getParameters().put("oai_syncEpr", progressProvider.getEpr().toString());
		job.getParameters().put("oai_recordSource", token.getEnv().getAttribute("oai_recordSource"));
		job.getParameters().put("oai_formatName", token.getEnv().getAttribute("oai_formatName"));
		job.getParameters().put("oai_formatLayout", token.getEnv().getAttribute("oai_formatLayout"));
		job.getParameters().put("oai_formatInterpretation", token.getEnv().getAttribute("oai_formatInterpretation"));
		log.fatal("Job prepared");
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	@Required
	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

}
