package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.oai.workflows.InaccurateProgressProvider;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;

public class RefreshSetsFromConfigJobNode extends BlackboardJobNode implements ProgressJobNode {

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='OAIStoreServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {
		job.setAction("REFRESH_CONFIG");
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return new InaccurateProgressProvider();
	}

}
