/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer;

import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.visual.GraphImageMapCreator;
import com.googlecode.sarasvati.visual.GraphToImageMap;
import com.googlecode.sarasvati.visual.ProcessImageMapCreator;
import com.googlecode.sarasvati.visual.ProcessToImageMap;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer.GraphToImageMapHelper;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer.MetaGraphToImageMapHelper;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer.ProcessToImageMapHelper;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.msro.workflows.sarasvati.loader.GraphLoader;
import eu.dnetlib.msro.workflows.sarasvati.registry.GraphProcessRegistry;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.annotation.Resource;

public class ProcessGraphGenerator {
    @Resource
    private GraphProcessRegistry graphProcessRegistry;
    @Resource
    private ISLookupClient isLookupClient;
    @Resource
    private GraphLoader graphLoader;

    public BufferedImage getProcessImage(String procId) throws Exception {
        GraphProcess proc = this.graphProcessRegistry.findProcess(procId);
        ProcessImageMapCreator imageMapCreator = new ProcessImageMapCreator(proc, (ProcessToImageMap)new ProcessToImageMapHelper(procId));
        return imageMapCreator.getImage();
    }

    public String getProcessImageMap(String procId) throws Exception {
        GraphProcess proc = this.graphProcessRegistry.findProcess(procId);
        ProcessImageMapCreator imageMapCreator = new ProcessImageMapCreator(proc, (ProcessToImageMap)new ProcessToImageMapHelper(procId));
        return imageMapCreator.getMapContents();
    }

    public BufferedImage getWfDescImage(String id, String xml, Set<String> notConfiguredNodes) throws Exception {
        Graph graph = this.graphLoader.loadGraph(xml);
        GraphImageMapCreator creator = new GraphImageMapCreator(graph, (GraphToImageMap)new GraphToImageMapHelper(id, notConfiguredNodes));
        return creator.getImage();
    }

    public String getWfDescImageMap(String id, String xml) throws Exception {
        Graph graph = this.graphLoader.loadGraph(xml);
        GraphImageMapCreator creator = new GraphImageMapCreator(graph, (GraphToImageMap)new GraphToImageMapHelper(id, null));
        return creator.getMapContents();
    }

    public BufferedImage getMetaWfDescImage(String id, String xml) throws Exception {
        Graph graph = this.graphLoader.loadGraph(xml);
        GraphImageMapCreator creator = new GraphImageMapCreator(graph, (GraphToImageMap)new MetaGraphToImageMapHelper());
        return creator.getImage();
    }

    public String getMetaWfDescImageMap(String id, String xml) throws Exception {
        Graph graph = this.graphLoader.loadGraph(xml);
        GraphImageMapCreator creator = new GraphImageMapCreator(graph, (GraphToImageMap)new MetaGraphToImageMapHelper());
        return creator.getMapContents();
    }
}

