/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AbstractWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.util.HashSet;
import java.util.Set;

public class DatasourceWorkflowDescriptor
extends AbstractWorkflowDescriptor {
    private String dsId;
    private Set<String> dsProtocols;
    private String dsTypology;
    private Set<MetaWorkflowDescriptor> metaworkflows;
    private Set<String> wfFamilyNames;
    private Set<String> wfStatuses;

    public DatasourceWorkflowDescriptor(String dsId, String name, Set<String> dsProtocols, String dsTypology, Set<MetaWorkflowDescriptor> metaworkflows) {
        super(dsId, name, "");
        this.dsId = dsId;
        this.dsProtocols = Sets.newHashSet();
        for (String s : dsProtocols) {
            this.dsProtocols.add("@" + s + "@");
        }
        this.dsTypology = "@" + dsTypology + "@";
        this.setMetaworkflows(metaworkflows != null ? metaworkflows : new HashSet());
        this.wfFamilyNames = Sets.newHashSet();
        this.wfStatuses = Sets.newHashSet();
        if (metaworkflows.isEmpty()) {
            this.setCssClass("wf_missing");
        } else {
            for (MetaWorkflowDescriptor mw : metaworkflows) {
                this.wfFamilyNames.add("@" + mw.getFamilyName() + "@");
                this.wfStatuses.add("@" + mw.getStatusEnum().toString() + "@");
                switch (mw.getStatusEnum()) {
                    case ASSIGNED: 
                    case WAIT_SYS_SETTINGS: 
                    case WAIT_USER_SETTINGS: {
                        this.setCssClass("wf_warning");
                        return;
                    }
                }
            }
        }
        if (this.wfStatuses.isEmpty()) {
            this.wfStatuses.add(WorkflowsConstants.WorkflowStatus.MISSING.toString());
        }
    }

    public DatasourceWorkflowDescriptor(DatasourceWorkflowDescriptor desc) {
        this(desc.getDsId(), desc.getName(), desc.getDsProtocols(), desc.getDsTypology(), desc.getMetaworkflows());
    }

    public Set<String> getDsProtocols() {
        return this.dsProtocols;
    }

    public void setDsProtocols(Set<String> dsProtocols) {
        this.dsProtocols = dsProtocols;
    }

    public String getDsTypology() {
        return this.dsTypology;
    }

    public void setDsTypology(String dsTypology) {
        this.dsTypology = dsTypology;
    }

    public String getDsId() {
        return this.dsId;
    }

    public void setDsId(String dsId) {
        this.dsId = dsId;
    }

    public Set<MetaWorkflowDescriptor> getMetaworkflows() {
        return this.metaworkflows;
    }

    public void setMetaworkflows(Set<MetaWorkflowDescriptor> metaworkflows) {
        this.metaworkflows = metaworkflows;
    }

    public Set<String> getWfStatuses() {
        return this.wfStatuses;
    }

    public void setWfStatuses(Set<String> wfStatuses) {
        this.wfStatuses = wfStatuses;
    }
}

