package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.io.StringReader;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.google.common.collect.Lists;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class OaiListSetsValues extends ValidNodeValuesFetcher {

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private SAXReader reader = new SAXReader();
	private HttpClient client = new HttpClient();

	private static final Log log = LogFactory.getLog(OaiListSetsValues.class);

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {
		if (params.containsKey("baseUrl")) {
			return executeListSets(params.get("baseUrl"));
		} else {
			verifyParams(params, "dsId", "ifaceId");
			final String baseUrl = obtainBaseUrl(params.get("dsId"), params.get("ifaceId"));
			return executeListSets(baseUrl);
		}
	}

	private String obtainBaseUrl(final String dsId, final String ifaceId) throws Exception {
		final String profile = lookupLocator.getService().getResourceProfile(dsId);

		final Document doc = reader.read(new StringReader(profile));

		final Node iface = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");

		if (!iface.valueOf("./ACCESS_PROTOCOL").equalsIgnoreCase("oai")) {
			log.error("Invalid protocol for interface " + ifaceId);
			throw new MSROException("Invalid protocol for interface " + ifaceId);
		}

		return iface.valueOf("./BASE_URL");
	}

	private List<DnetParamValue> executeListSets(final String baseUrl) throws Exception {
		final GetMethod method = new GetMethod(baseUrl);
		method.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
		method.setQueryString(new NameValuePair[] { new NameValuePair("verb", "ListSets") });

		int responseCode = client.executeMethod(method);

		if (HttpStatus.SC_OK != responseCode) {
			log.error("Error downloading listSets from baseUrl: " + baseUrl);
			throw new CollectorServiceException("Error " + responseCode + " dowloading ListSets: " + method.getURI());
		}

		final Document responseDoc = reader.read(method.getResponseBodyAsStream());

		final List<DnetParamValue> list = Lists.newArrayList();

		for (Object o : responseDoc.selectNodes("//*[local-name()='set']")) {
			final Node n = (Node) o;
			final String setSpec = n.valueOf("./*[local-name()='setSpec']");
			final String setName = n.valueOf("./*[local-name()='setName']");
			list.add(new DnetParamValue(setSpec, setName));
		}

		return list;
	}
}
