package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer;

import javax.swing.Icon;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.ProcessToImageMapAdapter;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;

import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.ProcessJobIcon;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;

public class ProcessToImageMapHelper extends ProcessToImageMapAdapter {

	private String procId;

	public ProcessToImageMapHelper(final String procId) {
		super();
		this.procId = procId;
	}

	@Override
	public String hrefForNode(final VisualProcessNode node) {
		return "javascript:getScope('map').getProcessNode('" + procId + "', '" + node.getNode().getId() + "')";
	}

	@Override
	public String hoverForNode(final VisualProcessNode node) {
		return "Name: " + node.getNode().getName();
	}

	@Override
	public Icon iconForNode(final VisualProcessNode vnode) {
		final Node node = vnode.getNode();

		final ProgressProvider progressProvider = (node instanceof ProgressJobNode) ? ((ProgressJobNode) node).getProgressProvider() : null;

		return new ProcessJobIcon(node, vnode.getToken(), progressProvider);
	}
}
