package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import java.util.Set;

import javax.annotation.Resource;

import com.google.common.collect.Sets;

import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;

public class WorkflowSectionGrouper {
	
	

	@Resource
	private DataproviderWorkflowSection dataproviderWorkflowSection;

	private Set<String> cache = Sets.newHashSet();
	private long cacheDate = 0;
	private static final long CACHE_DURATION = 600000; // 10 minutes
	
	@Resource
	private ISLookupClient isLookupClient;
			
	public DataproviderWorkflowSection getDataproviderWorkflowSection() {
		return dataproviderWorkflowSection;
	}

	public AbstractWorkflowSection getSectionByName(String name) {
		if (dataproviderWorkflowSection.getName().equals(name)) {
			return dataproviderWorkflowSection;
		}
		return new MetaWorkflowSection(name, isLookupClient.listMetaWorflowsForSection(name));
	}

	public Set<String> getAllSectionNames(boolean withDataproviders) {
		synchronized (cache) {
			if (cache.isEmpty() || DateUtils.now() - cacheDate > CACHE_DURATION) {
				cache.clear();
				cache.addAll(isLookupClient.listSimpleWorflowSections());
				cacheDate = DateUtils.now();
			}
		}
		
		final Set<String> res = Sets.newHashSet(cache);
				
		if (withDataproviders) {
			res.add(dataproviderWorkflowSection.getName());
		} else {
			res.remove(dataproviderWorkflowSection.getName());
		}
		return res;
	}
	
}
