package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.NodeToken;

import edu.emory.mathcs.backport.java.util.Collections;

public class NodeTokenInfo {
	
	public class EnvParam {
		private String name;
		private String value;
				
		public EnvParam(String name, String value) {
			this.name = name;
			this.value = value;
		}
		
		public String getName() {
			return name;
		}
		public String getValue() {
			return value;
		}
	}
	
	private String name;
	private String start;
	private String end;
	private List<EnvParam> params;
	
	public NodeTokenInfo(final String name) {
		super();
		this.name = name;
		this.start = "-";
		this.end = "-";
		this.params = Lists.newArrayList();
	}
		
	public NodeTokenInfo(final NodeToken token) {
		super();
		
		final Date start = token.getCreateDate();
		final Date end = token.getCompleteDate();
		
		this.name = token.getNode().getName();
		this.start = (start == null) ? "-" : start.toString();
		this.end = (end == null) ? "-" : end.toString();

		
		
		final Map<String, EnvParam> map = Maps.newHashMap(); 
		for (String name : token.getFullEnv().getAttributeNames()) {
			map.put(name, new EnvParam(name, token.getFullEnv().getAttribute(name)));
		}
		for (String name : token.getEnv().getAttributeNames()) {
			map.put(name, new EnvParam(name, token.getEnv().getAttribute(name)));			
		}
		
		this.params = Lists.newArrayList(map.values());
		
		Collections.sort(this.params, new Comparator<EnvParam>() {
			@Override
			public int compare(EnvParam o1, EnvParam o2) {
				return o1.getName().compareTo(o2.getName());
			}
		});
	}

	public String getName() {
		return name;
	}
	public String getStart() {
		return start;
	}
	public String getEnd() {
		return end;
	}
	public List<EnvParam> getParams() {
		return params;
	}
}
