var module = angular.module('wfJournalUI', ['ngGrid','$strap.directives']);

function formatDate(date) {
	return date.getFullYear() + '-' + (date.getMonth()+1) + '-' + date.getDate();
}

function wfJournalCtrl($scope, $http) {
	initSpinner();
	
	$scope.journal = [];
	$scope.currentLog = [];
	$scope.currentSimpleLog = [];
	$scope.currentAdvancedLog = [];
	$scope.currentProcId = '';
	
	$scope.filterJournal = {
		filterText: ''
	};
	
	// Set date range to [3 days before today, today] inclusive
	$scope.endDate = new Date();
	$scope.startDate = new Date();
	$scope.startDate.setDate($scope.endDate.getDate()-3); 
	
	// Grid configuration
	$scope.gridWfJournal = { 
			data: 'journal',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			enableHighlighting: true,
			sortInfo: { fields: ['date'], directions: ['desc']},
			filterOptions: $scope.filterJournal,
			columnDefs: [{field: 'procId',   displayName: 'Process ID'     , width: '15%', cellTemplate: '<div class="ngCellText"><a href="#" ng-click="showLogDetails(row.getProperty(col.field))">{{row.getProperty(col.field)}}</a></div>'},
			             {field: 'wfName',   displayName: 'Workflow name' },
			             {field: 'wfFamily', displayName: 'Workflow family', width: '15%' },
			             {field: 'wfStatus', displayName: 'Status'         , width: '10%', cellTemplate: '<div class="ngCellText"><span class="label" ng-class="{ \'label-success\': row.getProperty(col.field) == \'SUCCESS\', \'label-important\': row.getProperty(col.field) == \'FAILURE\', \'label-info\': row.getProperty(col.field) == \'EXECUTING\'}">{{row.getProperty(col.field)}}</span></div>'},
			             {field: 'date',     displayName: 'Date'           , width: '15%', cellTemplate: '<div class="ngCellText">{{row.getProperty("prettyDate")}}</div>'}
			            ]
	};
	
	$scope.gridLogDetails = { 
			data: 'currentLog',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			sortInfo: { fields: ['k'], directions: ['asc'] },
			columnDefs: [{field: 'k', displayName: 'Key', width: '20%' },
			             {field: 'v', displayName: 'Value' }]
	};
		
	$scope.showError = function(error) {
		show_notification("error", error);
	}
	
	$scope.showNotification = function(message) {
		show_notification("info", message);
	}
	
	$scope.showSpinner = function() {
		showSpinner();
	}

	$scope.hideSpinner = function() {
		hideSpinner();
	}
		
	$scope.refresh = function() {
		$scope.showSpinner();
		
		$http.get('wf_journal.range?start=' + formatDate($scope.startDate) + '&end=' + formatDate($scope.endDate))
        .success(
            function(data) {
                $scope.journal = data;
                $scope.hideSpinner();
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.showLogDetails = function(procId) {
		$scope.showSpinner();
		$scope.currentProcId = procId;
		
		$http.get('wf_journal.get?id=' + procId)
        .success(
            function(data) {
                $scope.currentAdvancedLog = data;
                $scope.currentSimpleLog = [];
                angular.forEach(data, function(value, key){
	            	if ((/^dataprovider\:/).test(value.k) || (/^mainlog\:/).test(value.k)) {
	            		$scope.currentSimpleLog.push(value);
					}
				});
                $scope.currentLog = $scope.currentSimpleLog;
                $scope.hideSpinner();
                $('#logDetailsModal').modal('show');
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.resizeMainElement = function(elem) {
		var height = 0;
		var body = window.document.body;
		if (window.innerHeight) {
			height = window.innerHeight;
		} else if (body.parentElement.clientHeight) {
			height = body.parentElement.clientHeight;
		} else if (body && body.clientHeight) {
			height = body.clientHeight;
		}
		elem.style.height = ((height - elem.offsetTop - 80) + "px");
	}
	
	$scope.refresh();
	$scope.resizeMainElement(document.getElementById('wfJournalTable'));
	
	if (initProcId()) {
		$scope.showLogDetails(initProcId());
	}
}

window.onresize = function() {
	var elem = document.getElementById('wfJournalTable');
    angular.element(elem).scope().resizeMainElement(elem);
};