/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AdvancedMetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AtomicWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.DatasourceWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeInfo;
import eu.dnetlib.functionality.modular.ui.workflows.util.TransformerUtils;
import eu.dnetlib.msro.workflows.util.WorkflowParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISLookupClient {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(ISLookupClient.class);

    public List<String> listSimpleWorflowSections() {
        String xquery = "distinct-values(//METAWORKFLOW_SECTION/text())";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(//METAWORKFLOW_SECTION/text())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error obtaining worflowSections", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<MetaWorkflowDescriptor> listMetaWorflowsForSection(String name) {
        String query = this.queryForMetaWorkflowDescriptor(".//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//METAWORKFLOW_SECTION='" + name + "'");
        try {
            return Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query), TransformerUtils.toMetaWorkflow);
        }
        catch (ISLookUpException e) {
            return Lists.newArrayList();
        }
    }

    public AtomicWorkflowDescriptor getAtomicWorkflow(String id) {
        String s = this.getProfile(id);
        return (AtomicWorkflowDescriptor)TransformerUtils.toAtomicWorkflow.apply((Object)s);
    }

    public List<DatasourceWorkflowDescriptor> listDatasources() {
        String query = this.queryForDatasourceWorkflowDescriptor("collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')");
        try {
            return Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query), TransformerUtils.toDatasourceWorkflow);
        }
        catch (ISLookUpException e) {
            return Lists.newArrayList();
        }
    }

    public DatasourceWorkflowDescriptor getDatasourceWorkflow(String id) {
        String query = this.queryForDatasourceWorkflowDescriptor("/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']");
        try {
            String s = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            return (DatasourceWorkflowDescriptor)TransformerUtils.toDatasourceWorkflow.apply((Object)s);
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    private String queryForDatasourceWorkflowDescriptor(String coll) {
        return "for $x in " + coll + " return <record>" + "<dsId>{$x//RESOURCE_IDENTIFIER/@value/string()}</dsId>" + "<dsName>{$x//OFFICIAL_NAME/text()}</dsName>" + "<protocols>{$x//ACCESS_PROTOCOL}</protocols>" + "<dsType>{$x//DATASOURCE_TYPE/text()}</dsType>" + "<metaworkflows>" + "{" + "for $y in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') " + "where $y//DATAPROVIDER/@id=$x//RESOURCE_IDENTIFIER/@value " + "return <workflow " + "id='{$y//RESOURCE_IDENTIFIER/@value/string()}' " + "name='{$y//METAWORKFLOW_NAME/text()}' " + "family='{$y//METAWORKFLOW_NAME/@family/string()}' " + "status='{$y//CONFIGURATION/@status/string()}' /> " + "}" + "</metaworkflows>" + "</record>";
    }

    private String queryForMetaWorkflowDescriptor(String cond) {
        return "for $x in /*[" + cond + "]\n" + "return concat(" + "$x//RESOURCE_IDENTIFIER/@value, ' @@@ ', " + "$x//METAWORKFLOW_NAME, ' @@@ ', " + "$x//METAWORKFLOW_NAME/@family, ' @@@ ', " + "$x//CONFIGURATION/@status)";
    }

    public String getProfile(String id) {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(id);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error finding profile: " + id), (Throwable)e);
            return null;
        }
    }

    public String getSarasvatiMetaWorkflow(String id) {
        String s = this.getProfile(id);
        return TransformerUtils.toSarasvatiMetaWorkflow.evaluate((Object)s);
    }

    public NodeInfo getNodeInfo(String wfId, String nodeName) {
        try {
            String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + wfId + "']//NODE[@name='" + nodeName + "']";
            String xml = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            return (NodeInfo)TransformerUtils.toNodeInfo.apply((Object)xml);
        }
        catch (Exception e) {
            log.error((Object)("Error accessing node " + nodeName + " of wf " + wfId), (Throwable)e);
            return new NodeInfo("", "", new ArrayList<WorkflowParam>(), new ArrayList<WorkflowParam>());
        }
    }

    public Set<String> getNotConfiguredNodes(String id) {
        String query = "for $x in (/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//NODE) " + "where count($x//PARAM[@required='true' and string-length(normalize-space(.)) = 0]) > 0 " + "return $x/@name/string()";
        try {
            List list = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query);
            return Sets.newHashSet((Iterable)list);
        }
        catch (Exception e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public AdvancedMetaWorkflowDescriptor getMetaWorkflow(String id) {
        String s = this.getProfile(id);
        return (AdvancedMetaWorkflowDescriptor)TransformerUtils.toAdvancedMetaWorkflow.apply((Object)s);
    }

    public Map<String, String> listRepoHiWorkflows() {
        HashMap map = Maps.newHashMap();
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)";
        try {
            for (String s : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)")) {
                String[] arr = s.split("@@@");
                map.put(arr[0].trim(), arr[1].trim());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing xquery: for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)", (Throwable)e);
        }
        return map;
    }

    public List<String> listMetaWorflowsForWfId(String wfId) {
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//WORKFLOW/@id='" + wfId + "' return $x//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public boolean isExecutable(String metaWfId) {
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')[.//RESOURCE_IDENTIFIER/@value = '" + metaWfId + "']//WORKFLOW/@id \n" + "for $y in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType')[.//RESOURCE_IDENTIFIER/@value = $x]//PARAM[@required='true' and string-length(normalize-space(.)) = 0] \n" + "return $y";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query).isEmpty();
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return false;
        }
    }

    public List<String> listWfFamilies() {
        String query = "distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error executing xquery: distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())", (Throwable)e);
            return Lists.newArrayList();
        }
    }
}

