/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.AbstractWorkflowSection;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.DataproviderWorkflowSection;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.MetaWorkflowSection;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;

public class WorkflowSectionGrouper {
    @Resource
    private DataproviderWorkflowSection dataproviderWorkflowSection;
    private Set<String> cache = Sets.newHashSet();
    private long cacheDate = 0L;
    private static final long CACHE_DURATION = 600000L;
    @Resource
    private ISLookupClient isLookupClient;

    public DataproviderWorkflowSection getDataproviderWorkflowSection() {
        return this.dataproviderWorkflowSection;
    }

    public AbstractWorkflowSection getSectionByName(String name) {
        if (this.dataproviderWorkflowSection.getName().equals(name)) {
            return this.dataproviderWorkflowSection;
        }
        return new MetaWorkflowSection(name, this.isLookupClient.listMetaWorflowsForSection(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllSectionNames(boolean withDataproviders) {
        Set<String> set = this.cache;
        synchronized (set) {
            if (this.cache.isEmpty() || DateUtils.now() - this.cacheDate > 600000L) {
                this.cache.clear();
                this.cache.addAll(this.isLookupClient.listSimpleWorflowSections());
                this.cacheDate = DateUtils.now();
            }
        }
        HashSet res = Sets.newHashSet(this.cache);
        if (withDataproviders) {
            res.add(this.dataproviderWorkflowSection.getName());
        } else {
            res.remove(this.dataproviderWorkflowSection.getName());
        }
        return res;
    }
}

