package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import java.util.List;

import javax.annotation.Resource;

import com.google.common.collect.Lists;

import edu.emory.mathcs.backport.java.util.Collections;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AbstractWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.DatasourceWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;

public class DataproviderWorkflowSection extends AbstractWorkflowSection {

	@Resource
	private ISLookupClient isLookupClient;

	@Override
	public List<? extends AbstractWorkflowDescriptor> listWorkflows() {
		final List<DatasourceWorkflowDescriptor> list = Lists.newArrayList();
		for (DatasourceWorkflowDescriptor d : isLookupClient.listDatasources()) {
			if (!d.getMetaworkflows().isEmpty()) {
				list.add(d);
			}
		}
		Collections.sort(list);
		return list;
	}

	public DatasourceWorkflowDescriptor getWorkflow(final String dsId) {
		return isLookupClient.getDatasourceWorkflow(dsId);
	}

}
