package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.ui.ModelMap;

import com.google.gson.Gson;

import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.workflows.objects.FilterCollection;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class DataProviderEntryPointController extends ModuleEntryPoint {

	private String datasourcefilterValues = "";

	@Resource
	private WorkflowsConstants workflowsConstants;

	@Resource
	private WorkflowSectionGrouper workflowSectionGrouper;

	@Resource
	private ISLookupClient isLookupClient;

	@Override
	protected void initialize(final ModelMap map, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final Gson gson = new Gson();

		if (datasourcefilterValues.isEmpty()) {

			final FilterCollection coll = new FilterCollection();

			coll.addElement("dsProtocols", "All", "icon-list", "");
			for (Map<String, String> m : workflowsConstants.getDataproviderProtocols()) {
				coll.addElement("dsProtocols", m.get("name"), m.get("icon"), m.get("value"));
			}

			coll.addElement("dsTypologies", "All", "icon-list", "");
			for (Map<String, String> m : workflowsConstants.getDataproviderTypologies()) {
				coll.addElement("dsTypologies", m.get("name"), m.get("icon"), m.get("value"));
			}

			coll.addElement("wfStatuses", "All", "icon-list", "");
			for (Map<String, String> m : workflowsConstants.getDataproviderWorkflowStatuses()) {
				coll.addElement("wfStatuses", m.get("name"), m.get("icon"), m.get("value"));
			}

			coll.addElement("repohiWfs", "All", "icon-list", "");
			for (Map.Entry<String, String> e : isLookupClient.listRepoHiWorkflows().entrySet()) {
				coll.addElement("repohiWfs", e.getValue(), "icon-wrench", e.getKey());
			}

			coll.addElement("wfFamilies", "All", "icon-list", "");
			for (String s : isLookupClient.listWfFamilies()) {
				coll.addElement("wfFamilies", s, "icon-wrench", s);
			}

			datasourcefilterValues = gson.toJson(coll);
		}

		map.addAttribute("datasourcefilterValues", datasourcefilterValues);

		if (request.getParameterMap().containsKey("metaWf")) {
			map.addAttribute("initialMetaWf", request.getParameter("metaWf"));
		}

	}
}
