<fieldset>
	<legend>
		{{currentWorkflow.name}}
		<span class="text-info" style="font-size:12px;" ng-show="titleAlternative"> ({{titleAlternative}})</span>
	</legend>
	<div>
		<p>
			<b>Last execution date:</b> 
			<span ng-show="currentWorkflow.lastExecutionDate">
				<a href="javascript:void(0)" data-toggle="modal" data-target="#journalWfModal" ng-click="updateWfJournal(currentWorkflow.wfId)"><i>{{currentWorkflow.lastExecutionDate}}</i></a>
			</span>
			<span ng-show="!currentWorkflow.lastExecutionDate"><i>not yet launched</i></span>
		</p>
	
		<form class="form-inline">
			<button class="btn" ng-click="getMetaWorkflow(currentMetaWorkflow.wfId)">back</button>
			<div class="btn-group">
			    <a class="btn" href="#" ng-click="executeWf()" ng-disabled="!currentWorkflow.ready || currentWorkflow.start == 'disabled'">launch now</a>
				<a class="btn btn-primary dropdown-toggle" data-toggle="dropdown" href="#"><span class="caret"></span></a>
				<ul class="dropdown-menu">
					<li ng-class="{ active : currentWorkflow.start == 'auto'}"><a href="#" ng-click="enableCurrentWf('auto')">automatic start</a></li>
					<li ng-class="{ active : currentWorkflow.start == 'manual'}"><a href="#" ng-click="enableCurrentWf('manual')">manual start</a></li>
					<li ng-class="{ active : currentWorkflow.start == 'disabled'}"><a href="#" ng-click="enableCurrentWf('disabled')">disabled</a></li>
					<li class="divider"></li>
					<li><a href="#" ng-click="showPriorityDialog()">change priority</a></li>
				</ul>
		    </div>
			<label ng-show="!currentWorkflow.ready">Configure the <span class="label label-important">RED</span> nodes before launching this workflow</label>
			<label ng-show="currentWorkflow.ready && currentWorkflow.start == 'disabled'"><span class="label label-important">ATTENTION</span> this workflow is currently disabled</label>
			<label ng-show="currentWorkflow.ready && currentWorkflow.start == 'manual'"><span class="label label-info">ATTENTION</span> this workflow can be launched only manually</label>
		</form>
	</div>
	<div>
		<map name="processAtomicWorkflowMap" id="processAtomicWorkflowMap" ng-bind-html-unsafe="currentWorkflow.mapContent"></map>
		<img style="border:2px black solid" ng-src="{{currentWorkflow.imageUrl}}" usemap="#processAtomicWorkflowMap"/>
		<label>Click on the nodes to edit params</label>
	</div>
</fieldset>