var module = angular.module('workflowsUI', ['ngGrid']);    

function getScope(selector) {
	return angular.element($(selector)).scope();
}

function workflowsCtrl($scope, $http) {
   
	commonInitialize($scope, $http);
    
    $scope.currentSection = "";
    		
	$scope.initSection = function() {
		$scope.currentSection = getSection();
		$scope.getWorkflowsForSection($scope.currentSection, true);
	}
	
	$scope.getWorkflowsForSection = function(section, loadFirstElement) {
		$scope.showSpinner();
		
		$http.get('wf_metaworkflowsForSection.json?section='+section)
        .success(
            function(data) {
                $scope.currentSection = section;
                $scope.metaworkflows = data;
                $scope.hideSpinner();
				if (loadFirstElement) {
					$scope.getMetaWorkflow($scope.metaworkflows[0].wfId);
				} else {
					angular.forEach($scope.metaworkflows, function(value, key){
						if (value.wfId == $scope.currentMetaWorkflow.wfId) {
							$scope.currentMetaWorkflow = value;
						}
					});
				}
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}
		
	$scope.cloneMetaWf = function(id, name) {
		$scope.showSpinner();
		$http.get('wf_metaworkflow.clone?id=' + id +'&name=' + name)
        .success(
            function(data) {
            	$scope.hideSpinner();
				$scope.getWorkflowsForSection($scope.currentSection, false);
				$scope.getMetaWorkflow(JSON.parse(data));
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.initSection();
	
}
