var module = angular.module('wfTimelineUI', ['ngGrid','$strap.directives']);

function formatDate(date) {
	return date.getFullYear() + '-' + (date.getMonth()+1) + '-' + date.getDate();
}

function wfTimelineCtrl($scope, $http, $filter) {
	initSpinner();
	
	// Set date range to [3 days before today, today] inclusive
	$scope.endDate = new Date();
	$scope.startDate = new Date();
	$scope.startDate.setDate($scope.endDate.getDate()-3); 

	$scope.data= [];
	$scope.timeline = new links.Timeline(document.getElementById('divTimeline'));		
	$scope.timelineData = [];
	$scope.currentLog = [];
	$scope.currentLogTitle = '';
	
	$scope.gridLogDetails = { 
			data: 'currentLog',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			sortInfo: { fields: ['k'], directions: ['asc'] },
			columnDefs: [{field: 'k', displayName: 'Key', width: '20%' },
			             {field: 'v', displayName: 'Value' }]
	};
	
	$scope.registerListener = function() {
		google.visualization.events.addListener($scope.timeline, 'select', function() {
	        var sel = $scope.timeline.getSelection();
	        if (sel.length) {
	            if (sel[0].row != undefined) {
	                var row = sel[0].row;
	                $scope.showLogDetails($scope.timelineData[row]);
	            }
	        }
	    });
	}
	
	
	$scope.showError = function(error) {
		show_notification("error", error);
	}
	
	$scope.showNotification = function(message) {
		show_notification("info", message);
	}
		
	$scope.showSpinner = function() {
		showSpinner();
	}

	$scope.hideSpinner = function() {
		hideSpinner();
	}
	
	$scope.refresh = function() {
		$scope.showSpinner();
		$http.get('wf_journal.range?start=' + formatDate($scope.startDate) + '&end=' + formatDate($scope.endDate))
        .success(
            function(data) {
            	$scope.data = data;
                $scope.drawVisualization($scope.data);
                $scope.hideSpinner();
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.resizeMainElement = function(elem) {
		var height = 0;
		var body = window.document.body;
		if (window.innerHeight) {
			height = window.innerHeight;
		} else if (body.parentElement.clientHeight) {
			height = body.parentElement.clientHeight;
		} else if (body && body.clientHeight) {
			height = body.clientHeight;
		}
		elem.style.height = ((height - elem.offsetTop - 80) + "px");
	}
	
	
	$scope.drawVisualization = function(entries) {
		$scope.timelineData = [];

		angular.forEach(entries, function(value, key) {
			var clazz = 'success';
			if (value.wfStatus == 'FAILURE') {
				clazz = 'failure';
			}
			
			$scope.timelineData.push({
				'title': value.wfName + " (" + value.date + ")",
				'procId': value.procId,
                'start': new Date(value.date),
                'content': value.wfName,
                'className': clazz
            });
		});
		
		$scope.timeline = new links.Timeline(document.getElementById('divTimeline'));
		$scope.registerListener();
		var opts = {'width': '100%', 
					'height': '99%', 
					'style': 'box',
					'zoomMin': 1000000,
					'zoomMax': 31536000000,
					'min': $scope.startDate, 
					'max': $scope.endDate};
		$scope.timeline.draw($filter('filter')($scope.timelineData, $scope.filterText), opts);
    }
	
	$scope.showLogDetails = function(data) {
		$scope.showSpinner();
		$scope.currentLogTitle = data.title;
		$http.get('wf_journal.get?id=' + data.procId)
        .success(
            function(data) {
                $scope.currentLog = data;
                $scope.hideSpinner();
                $('#logDetailsModal').modal('show');
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}

	$scope.refresh();
	//$scope.timeline.setScale(links.Timeline.StepDate.SCALE.DAY, 1);
	$scope.resizeMainElement(document.getElementById('divTimeline'));
	
}

window.onresize = function() {
	var elem = document.getElementById('divTimeline');
    angular.element(elem).scope().resizeMainElement(elem);
    angular.element(elem).scope().timeline.redraw();
};