var module = angular.module('workflowsUI', ['ngGrid']);

function getScope(selector) {
	return angular.element($(selector)).scope();
}

function workflowsCtrl($scope, $http) {
	
	commonInitialize($scope, $http);
	
	$scope.initialMetaWf = getInitialMetaWf();
	
	$scope.datasourcefilterValues = getDatasourcefilterValues();

	$scope.getDsWorkflows = function(loadFirstElement) {
		$scope.showSpinner();
		
		$http.get('wf_dataproviders.json')
        .success(
            function(data) {
                $scope.metaworkflows = data;
                $scope.hideSpinner();
				if (loadFirstElement) {
					if ($scope.initialMetaWf) {
						angular.forEach($scope.metaworkflows, function(repo, key) {
							angular.forEach(repo.metaworkflows, function(mw, key) {
								if (mw.wfId == $scope.initialMetaWf) {
									$scope.getDataProviderMetaWorkflow(mw.wfId , repo.name);
									return;
								}
							});
						});
					} else if ($scope.metaworkflows.length > 0 && $scope.metaworkflows[0].metaworkflows.length > 0) {
						var id = $scope.metaworkflows[0].metaworkflows[0].wfId;
						var provider = $scope.metaworkflows[0].name;
						$scope.getDataProviderMetaWorkflow(id, provider);
					}
				} else {
					angular.forEach($scope.metaworkflows, function(value, key){
						if (value.wfId == $scope.currentMetaWorkflow.wfId) {
							$scope.currentMetaWorkflow = value;
						}
					});
				}
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}
	
	$scope.getDataProviderMetaWorkflow = function(id, provider) {
		$scope.titleAlternative = provider;
		$scope.getMetaWorkflow(id);
	}
		
	$scope.cloneMetaWf = function(id, name) {
		$scope.showSpinner();
		$http.get('wf_metaworkflow.clone?id=' + id +'&name=' + name)
        .success(
            function(data) {
            	$scope.hideSpinner();
				$scope.getDsWorkflows(false);
				$scope.getMetaWorkflow(JSON.parse(data));
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	
	$scope.updateSelectProtocolFilter = function(entry) {
		if (entry.value) {
			$scope.searchDs.dsProtocols = "@" + entry.value + "@"; // '@' is to avoid the match of "filesystem" when "file" is selected
			$scope.selectProtocol = entry.name;
		} else {
			$scope.searchDs.dsProtocols = '';
			$scope.selectProtocol = '';
		}
	}

	$scope.updateSelectTypologyFilter = function(entry) {
		if (entry.value) {
			$scope.searchDs.dsTypology = "@" + entry.value; // The end '@' is missing to match 'pubsrepository::*'
			$scope.selectTypology = entry.name;
		} else {
			$scope.searchDs.dsTypology = '';
			$scope.selectTypology = '';
		}
	}

	$scope.updateSelectWfName = function(entry) {
		if (entry.value) {
			$scope.searchDs.wfFamilyNames = "@" + entry.value + "@";
			$scope.selectWfName = entry.name;
		} else {
			$scope.searchDs.wfFamilyNames = '';
			$scope.selectWfName = '';
		}
	}
	
	$scope.updateSelectWfStatus = function(entry) {
		if (entry.value) {
			$scope.searchDs.wfStatuses = "@" + entry.value + "@";
			$scope.selectWfStatus = entry.name;
		} else {
			$scope.searchDs.wfStatuses = '';
			$scope.selectWfStatus = '';
		}
	}
	
	$scope.getDsWorkflows(true);
}
