function commonInitialize($scope, $http) {
	
	$scope.titleAlternative = '';
	
	$scope.searchDs = {};
	$scope.currentMetaWorkflow = {wfStatus : ''};
    $scope.currentWorkflow = {};
    $scope.currentProc = {};
    $scope.currentProcNode = {};
    $scope.currentNode = {};
    $scope.metaworkflows = [];
    $scope.currentTab = 'metawf';
	$scope.recentWorkflows = { running: 0, completed: 0, failed: 0, data: [] };
	$scope.recentWorkflowsSelection = [];
	$scope.currentWorkflowJournal = [];
	$scope.currentLogDetails = [];
	$scope.validParamValuesCache = {}; 
	
	$scope.filterRecentWfs = {
		filterText: ''
	};
	
	$scope.gridCurrentWfJournal = { 
			data: 'currentWorkflowJournal',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			sortInfo: { fields: ['date'], directions: ['desc'] },
			columnDefs: [{field: 'date',  width: '70%', displayName: 'Date', cellTemplate: '<div class="ngCellText"><a href="#" ng-click="showCurrentLogDetails(row.getProperty(\'procId\'), row.getProperty(col.field))">{{row.getProperty(col.field)}}</a></div>'},
			             {field: 'wfStatus', displayName: 'Status', cellTemplate: '<div class="ngCellText"><span class="label" ng-class="{ \'label-success\': row.getProperty(col.field) == \'SUCCESS\', \'label-important\': row.getProperty(col.field) == \'FAILURE\', \'label-info\': row.getProperty(col.field) == \'EXECUTING\'}">{{row.getProperty(col.field)}}</span></div>'}
			            ]
	};
	
	
	$scope.gridCurrentLogDetails = { 
			data: 'currentLogDetails',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			sortInfo: { fields: ['k'], directions: ['asc']},
			columnDefs: [{field: 'k', displayName: 'Key', width: '20%' },
			             {field: 'v', displayName: 'Value' }]
	};
	
	$scope.showError = function(error) {
		show_notification("error", error);
	}
	
	$scope.showNotification = function(message) {
		show_notification("info", message);
	}
		
	$scope.showSpinner = function() {
		showSpinner();
	}

	$scope.hideSpinner = function() {
		hideSpinner();
	}
	
	initSpinner();
	
	$scope.listValidValuesForUserParam = function(func) {
		if (!$scope.validParamValuesCache[func]) {
			$scope.showSpinner();
			try {
				$scope.validParamValuesCache[func] = eval(func);
			} catch (e) {
				alert('Error evaluating function: ' + func);
				$scope.validParamValuesCache[func] = [];
			}
			$scope.hideSpinner();
		} 
		return $scope.validParamValuesCache[func];
	}
	
	$scope.gridUserParams = { 
			data: 'currentNode.userParams',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: true,
			enablePaging: false,
			columnDefs: [{field: 'name', displayName: 'Name', enableCellEdit: false, width: '12%'},
			             {field: 'required', displayName: 'Required', enableCellEdit: false, width: '8%'},
			             {field: 'type', displayName: 'Type', enableCellEdit: false, width: '8%'},
			             {field: 'value', displayName:'Value', enableCellEdit: true, 
			            	 editableCellTemplate: 
			            		 "<input ng-show=\"!row.getProperty('function')\" type='text' ng-model='row.entity.value' ng-input='row.entity.value' ng-class=\"'colt' + col.index\" style='width: 98%;' />" + 
			            		 "<select ng-show=\"row.getProperty('function')\" ng-model='row.entity.value' ng-input='row.entity.value' ng-class=\"'colt' + col.index\" ng-options=\"item.id as item.name for item in listValidValuesForUserParam(row.getProperty('function'))\"><option value=''></option></select>" } 
			             ]
	};

	$scope.gridSystemParams = { 
			data: 'currentNode.systemParams',
			enableCellSelection: false,
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enablePaging: false,
			columnDefs: [{field: 'name',     displayName: 'Name',     width: '12%'},
			             {field: 'required', displayName: 'Required', width: '8%'},
			             {field: 'type',     displayName: 'Type',     width: '8%'},
			             {field: 'value',    displayName: 'Value'}]
	};
	
	$scope.gridRecentWorkflows = { 
			data: 'recentWorkflows.data',
			enableCellSelection: false,
			enableRowSelection: true,
			enableCellEditOnFocus: false,
			enablePaging: false,
			enableHighlighting: true,
			showSelectionCheckbox: true,
			sortInfo: { fields: ['lastActivity'], directions: ['desc']},
			selectedItems: $scope.recentWorkflowsSelection,
			filterOptions: $scope.filterRecentWfs,
			columnDefs: [{field: 'procId',       displayName: 'Process ID',      width: '15%', cellTemplate: '<div class="ngCellText"><a href="#" ng-click="showProcess(row.getProperty(col.field))">{{row.getProperty(col.field)}}</a></div>'},
			             {field: 'name',         displayName: 'Workflow name',   width: '40%'},
			             {field: 'family',       displayName: 'Workflow Family', width: '15%'},
			             {field: 'status',       displayName: 'Status',          width: '10%', cellTemplate: '<div class="ngCellText"><span class="label" ng-class="{ \'label-success\': row.getProperty(col.field) == \'SUCCESS\', \'label-important\': row.getProperty(col.field) == \'FAILURE\', \'label-info\': row.getProperty(col.field) == \'EXECUTING\'}">{{row.getProperty(col.field)}}</span></div>'},
			             {field: 'lastActivity', displayName: 'Last activity' }],
 			             
	};
	
	$scope.getMetaWorkflow = function(id) {
		$scope.showSpinner();
		$http.get('wf_metaworkflow.json?id='+id)
		.success(
				function(data) {
					$scope.currentMetaWorkflow = data;
					$scope.hideSpinner();
					$scope.currentTab = 'metawf';
				}
		).error(
				function() {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
		);
	}
	
	$scope.getAtomicWorkflow = function(id) {
		$scope.showSpinner();
		$http.get('wf_atomic_workflow.json?id='+id)
        .success(
            function(data) {
                $scope.currentWorkflow = data;
                $scope.hideSpinner();
				$scope.currentTab = 'atomwf';
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.getNode = function(wf, node) {
		$scope.showSpinner();
		$http.get('wf_workflow_node.json?wf=' + wf +'&node=' + node)
        .success(
            function(data) {
            	$scope.currentNode = data;
            	$scope.hideSpinner();
				$('#nodeEditModal').modal('show');
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}
	
	$scope.saveCurrentNode = function() {
		$scope.showSpinner();
		$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
		$http.post('wf_workflow_node.save', $.param({
			'wf'  : $scope.currentWorkflow.wfId,
			'json': JSON.stringify($scope.currentNode)
		}))
        .success(
            function(data) {
            	$scope.hideSpinner();
				$scope.getAtomicWorkflow($scope.currentWorkflow.wfId);
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}
	
	
	$scope.prepareMetaWfEdit = function() {
		$scope.tempMetaWorkflow = angular.copy($scope.currentMetaWorkflow);
	};
	
	$scope.saveCurrentMetaWf = function() {
		$scope.showSpinner();
		$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
		$http.post('wf_metaworkflow.edit', $.param({
			'json': JSON.stringify($scope.tempMetaWorkflow)
		}))
        .success(
            function(data) {
            	$scope.hideSpinner();
				
				angular.forEach($scope.metaworkflows, function(value, key){
					if (value.wfId == $scope.tempMetaWorkflow.wfId) {
						value.name = $scope.tempMetaWorkflow.name;
					}
				});
				
				$scope.getMetaWorkflow($scope.tempMetaWorkflow.wfId);
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	};
	
	$scope.executeWf = function() {
		$http.get('wf.start?id=' + $scope.currentWorkflow.wfId)
        .success(
        		function(data) {
        			$scope.updateRecentWorkflows();
        			$('#monitorWfModal').modal('show');
                }
        ).error(
                function() {
                	$scope.showError('Something really bad must have happened to our fellow hamster..');
                }
        );
	};
	
	$scope.executeMetaWf = function() {
		$http.get('metawf.start?id=' + $scope.currentMetaWorkflow.wfId)
        .success(
        		function(data) {
        			$scope.updateRecentWorkflows();
        			$('#monitorWfModal').modal('show');
                }
        ).error(
                function() {
                	$scope.showError('Something really bad must have happened to our fellow hamster..');
                }
        );
	};
	
	$scope.updateRecentWorkflows = function() {
		$http.get('recentWfs.list')
        .success(
        		function(data) {
        			$scope.hideSpinner();
        			$scope.updateRecentWorkflowsWithData(data);
                }
        ).error(
                function() {
                	$scope.showError('Something really bad must have happened to our fellow hamster..');
                }
        );
	};
	
	$scope.updateRecentWorkflowsWithData = function(data) {
		var running = 0;
		var completed = 0;
		var failed = 0;
		
		for(i=0; i<data.length; i++) {
			if      (data[i].status == 'SUCCESS')   { completed++; }
			else if (data[i].status == 'FAILURE')   { failed++;    }
			else if (data[i].status == 'EXECUTING') { running++;   }
		}

		$scope.recentWorkflows = {
			running   : running,
			completed : completed,
			failed    : failed,
			data      : data
		};
	}
	
	$scope.showProcess = function(procId) {
		$('#monitorWfModal').modal('hide');
		$scope.showSpinner();
		$http.get('wf_proc.json?id='+procId)
		.success(
				function(data) {
					$scope.currentProc = data;
					$scope.hideSpinner();
					$('#monitorProcWfModal').modal('show');
				}
		).error(
				function() {
					if (confirm("Not found in recent workflow list.\n\nDo you want to find it in Workflow history?")) {
						window.location.href = "workflow_journal.do?procId=" + procId;
					}
				}
		);
	}
	
	
	$scope.getProcessNode = function(procId, nodeId) {
		$('#monitorProcWfModal').modal('hide');
		$scope.showSpinner();
		$http.get('wf_proc_node.json?id=' + procId + "&node=" + nodeId)
		.success(
				function(data) {
					$scope.currentProcNode = data;
					$scope.hideSpinner();
					$('#monitorProcNodeModal').modal('show');
				}
		).error(
				function() {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
		);
	}
	
	$scope.deleteSelectedProcs = function() {
		var ids = [];
		angular.forEach($scope.recentWorkflowsSelection, function(value, key){
			if (value.status == 'SUCCESS' || value.status == 'FAILURE') {
				ids.push(value.procId);
			}
		});
		if (ids.length < $scope.recentWorkflowsSelection.length) {
			alert("Only termitated workflows can be deleted !");
		}
		$scope.deleteProcs(ids);
	}
	
	$scope.deleteProcsByStatus = function(status) {
		var ids = [];
		angular.forEach($scope.recentWorkflows.data, function(value, key){
			if (value.status == status) {
				ids.push(value.procId);
			}
		});
		$scope.deleteProcs(ids);
	}
	
	$scope.deleteProcs = function(ids) {
		$scope.showSpinner();
		$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
		$http.post('recentWfs.clear', $.param({
			'json': JSON.stringify(ids)
		}))
        .success(
            function(data) {
            	$scope.hideSpinner();
				$scope.updateRecentWorkflowsWithData(data);
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.killProcess = function(procId) {
		if (confirm("Are you sure ?")) {
			$scope.showSpinner();
			$http.get('wf_proc.kill?id='+procId)
			.success(
					function(data) {
						$scope.currentProc = data;
						$scope.hideSpinner();
						$('#monitorProcWfModal').modal('show');
					}
			).error(
					function() {
						$scope.showError('Something really bad must have happened to our fellow hamster..');
						$scope.hideSpinner();
					}
			);
		}
	}
	
	$scope.enableCurrentWf = function(val) {
		$scope.showSpinner();
		$http.get('wf_atomic_workflow.enable?start='+ val + "&id=" + $scope.currentWorkflow.wfId)
		.success(
				function(data) {
					$scope.currentWorkflow.start = val;
					$scope.hideSpinner();
				}
		).error(
				function() {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
		);
	}
	
	$scope.showPriorityDialog = function(b) {
		var s = prompt("New workflow priority [0..100]", $scope.currentWorkflow.priority);
		if (s==null) { return; }
		var value = parseInt(s);
		if (isNaN(value) || value < 0 || value > 100) {
			$scope.showError('Invalid value: ' + value);
			return;
		}
		$http.get('wf_atomic_workflow.priority?value='+ value + "&id=" + $scope.currentWorkflow.wfId)
		.success(
				function(data) {
					$scope.showNotification('Priority updated, new value is ' + value);
					$scope.currentWorkflow.priority = value;
					$scope.hideSpinner();
				}
		).error(
				function() {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
		);
	}
	
	$scope.updateWfJournal = function(id) {
		$scope.currentWorkflowJournal = [];
		
		$scope.showSpinner();
		
		$http.get('wf_journal.find?id=' + id)
        .success(
            function(data) {
                $scope.currentWorkflowJournal = data;
                $scope.hideSpinner();
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.showCurrentLogDetails = function(id, date) {
		$('#journalWfModal').modal('hide');
		
		$scope.showSpinner();
				
		$http.get('wf_journal.get?id=' + id)
        .success(
            function(data) {
                $scope.currentLogDate = date;
                $scope.currentLogDetails = data;
                $scope.hideSpinner();
                $('#currentLogDetailsModal').modal('show');
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );	
	}
		
	$scope.showSpinner();
}
