/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AdvancedMetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AtomicWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.DatasourceWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeInfo;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.util.WorkflowParam;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TransformerUtils {
    private static final Log log = LogFactory.getLog(TransformerUtils.class);
    public static final ApplyXslt toSarasvatiMetaWorkflow = new ApplyXslt((Source)new StreamSource(TransformerUtils.class.getResourceAsStream("/eu/dnetlib/msro/workflows/xslt/metawf_profile2sarasvati.xslt")));
    public static final Function<String, DatasourceWorkflowDescriptor> toDatasourceWorkflow = new Function<String, DatasourceWorkflowDescriptor>(){

        public DatasourceWorkflowDescriptor apply(String s) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(s));
                String dsId = doc.valueOf("//dsId");
                String name = doc.valueOf("//dsName");
                HashSet dsProtocols = Sets.newHashSet();
                for (Object o : doc.selectNodes("//protocols/ACCESS_PROTOCOL")) {
                    dsProtocols.add(((Node)o).getText());
                }
                String dsTypology = doc.valueOf("//dsType");
                HashSet metaworkflows = Sets.newHashSet();
                for (Object o : doc.selectNodes("//metaworkflows/workflow")) {
                    String wfId = ((Node)o).valueOf("@id");
                    String wfName = ((Node)o).valueOf("@name");
                    String wfStatusTemp = ((Node)o).valueOf("@status");
                    String wfFamily = ((Node)o).valueOf("@family");
                    WorkflowsConstants.WorkflowStatus wfStatus = wfStatusTemp == null || wfStatusTemp.isEmpty() ? WorkflowsConstants.WorkflowStatus.MISSING : WorkflowsConstants.WorkflowStatus.valueOf((String)wfStatusTemp);
                    metaworkflows.add(new MetaWorkflowDescriptor(wfId, wfName, wfStatus, wfFamily));
                }
                return new DatasourceWorkflowDescriptor(dsId, name, dsProtocols, dsTypology, metaworkflows);
            }
            catch (Exception e) {
                log.error((Object)("Error building DatasourceWorkflowDescriptor form xml: " + s), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
    };
    public static final Function<String, MetaWorkflowDescriptor> toMetaWorkflow = new Function<String, MetaWorkflowDescriptor>(){

        public MetaWorkflowDescriptor apply(String s) {
            Iterator iter = Splitter.on((String)"@@@").trimResults().split((CharSequence)s).iterator();
            String id = (String)iter.next();
            String name = (String)iter.next();
            String family = (String)iter.next();
            WorkflowsConstants.WorkflowStatus status = WorkflowsConstants.WorkflowStatus.valueOf((String)((String)iter.next()));
            return new MetaWorkflowDescriptor(id, name, status, family);
        }
    };
    public static final Function<String, NodeInfo> toNodeInfo = new Function<String, NodeInfo>(){

        public NodeInfo apply(String xml) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(xml));
                ArrayList userParams = Lists.newArrayList();
                ArrayList systemParams = Lists.newArrayList();
                for (Object o : doc.selectNodes("//PARAM")) {
                    Node n = (Node)o;
                    String key = n.valueOf("@name");
                    boolean required = "true".equalsIgnoreCase(n.valueOf("@required"));
                    String type = n.valueOf("@type");
                    String function = n.valueOf("@function");
                    String value = n.getText();
                    if ("user".equals(n.valueOf("@managedBy"))) {
                        userParams.add(new WorkflowParam(key, value, required, type, function));
                        continue;
                    }
                    systemParams.add(new WorkflowParam(key, value, required, type, function));
                }
                String name = doc.valueOf("/NODE/@name");
                String desc = doc.valueOf("//DESCRIPTION");
                return new NodeInfo(name, desc, userParams, systemParams);
            }
            catch (Exception e) {
                log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
                return new NodeInfo("", "", new ArrayList<WorkflowParam>(), new ArrayList<WorkflowParam>());
            }
        }
    };
    public static final Function<String, AtomicWorkflowDescriptor> toAtomicWorkflow = new Function<String, AtomicWorkflowDescriptor>(){

        public AtomicWorkflowDescriptor apply(String xml) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(xml));
                String id = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
                String name = doc.valueOf("//WORKFLOW_NAME");
                String imageUrl = "wf_atomic_workflow.img?id=" + id + "&t=" + DateUtils.now();
                String lastExecutionDate = doc.valueOf("//STATUS/LAST_EXECUTION_DATE");
                String start = doc.valueOf("//CONFIGURATION/@start");
                boolean ready = doc.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty();
                int priority = NumberUtils.toInt((String)doc.valueOf("//WORKFLOW_PRIORITY"), (int)50);
                return new AtomicWorkflowDescriptor(id, name, priority, "", null, imageUrl, ready, start, lastExecutionDate);
            }
            catch (Exception e) {
                log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
                return new AtomicWorkflowDescriptor("", "", 0, "", null, "", false, "disabled", "");
            }
        }
    };
    public static final Function<String, AdvancedMetaWorkflowDescriptor> toAdvancedMetaWorkflow = new Function<String, AdvancedMetaWorkflowDescriptor>(){

        public AdvancedMetaWorkflowDescriptor apply(String xml) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(xml));
                String id = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
                String name = doc.valueOf("//METAWORKFLOW_NAME");
                String family = doc.valueOf("//METAWORKFLOW_NAME/@family");
                String mapContent = null;
                String imageUrl = "wf_metaworkflow.img?id=" + id + "&t=" + DateUtils.now();
                String email = doc.valueOf("//ADMIN_EMAIL");
                boolean scheduled = Boolean.valueOf(doc.valueOf("//SCHEDULING/@enabled"));
                String cronExpression = doc.valueOf("//SCHEDULING/CRON");
                int minInterval = Integer.parseInt(doc.valueOf("//SCHEDULING/MININTERVAL"));
                WorkflowsConstants.WorkflowStatus status = WorkflowsConstants.WorkflowStatus.valueOf((String)doc.valueOf("//CONFIGURATION/@status"));
                return new AdvancedMetaWorkflowDescriptor(id, name, mapContent, imageUrl, email, scheduled, cronExpression, minInterval, status, family);
            }
            catch (Exception e) {
                log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
                return new AdvancedMetaWorkflowDescriptor("", "", "", "", "", false, "", 0, WorkflowsConstants.WorkflowStatus.MISSING, "");
            }
        }
    };
}

