/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.util.FontUtil;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.AbstractIcon;
import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import eu.dnetlib.msro.workflows.nodes.WorkflowNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class WorkflowIcon
extends AbstractIcon {
    private NodeStatus status = NodeStatus.DISABLED;

    public WorkflowIcon(Node node) {
        super(node);
        if (node instanceof WorkflowNode) {
            this.status = ((WorkflowNode)node).getStatus();
        }
        this.redrawImage();
    }

    public void redrawImage(Graphics2D gfx) {
        super.resetGfx(gfx);
        switch (this.status) {
            case CONFIGURED: {
                gfx.setColor(Color.decode("#336699"));
                break;
            }
            case NOT_CONFIGURED: {
                gfx.setColor(Color.decode("#bb0000"));
                break;
            }
            default: {
                gfx.setColor(Color.decode("#aabbcc"));
            }
        }
        gfx.fillRoundRect(0, 0, 99, HEIGHT - 1, 10, 10);
        gfx.setColor(NodeDrawConfig.NODE_BORDER);
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, this.getDashes(), 0.0f);
        gfx.setStroke(stroke);
        gfx.drawRoundRect(0, 0, 99, HEIGHT - 1, 10, 10);
        gfx.setColor(Color.white);
        int padding = 6;
        int startX = 6;
        int maxWidth = this.getIconWidth() - 12;
        FontUtil.setSizedFont((Graphics)gfx, (String)this.getLabel(), (float)10.0f, (int)maxWidth);
        int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds(this.getLabel(), gfx).getWidth());
        int strHeight = gfx.getFontMetrics().getAscent();
        int left = 6 + (maxWidth - strWidth >> 1);
        int top = this.getIconHeight() + strHeight >> 1;
        gfx.drawString(this.getLabel(), left, top);
        super.resetGfx(gfx);
    }
}

