/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.ProcessState;
import edu.emory.mathcs.backport.java.util.Collections;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AdvancedMetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AtomicWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeTokenInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.ProcessListEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.AbstractWorkflowSection;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.DataproviderWorkflowSection;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer.ProcessGraphGenerator;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISRegistryClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.sarasvati.loader.ProfileToSarasvatiConverter;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import eu.dnetlib.msro.workflows.sarasvati.registry.GraphProcessRegistry;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class WorkflowsController {
    @Resource
    private ISLookupClient isLookupClient;
    @Resource
    private ISRegistryClient isRegistryClient;
    @Resource
    private GraphProcessRegistry graphProcessRegistry;
    @Resource
    private ProcessGraphGenerator processGraphGenerator;
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private ProfileToSarasvatiConverter profileToSarasvatiConverter;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    private static final Log log = LogFactory.getLog(WorkflowsController.class);

    @RequestMapping(value={"/ui/wf_metaworkflowsForSection.json"})
    public void getMetaWorkflowsForSection(HttpServletResponse response, @RequestParam(value="section", required=true) String sectionName) throws ISLookUpException, IOException {
        AbstractWorkflowSection section = this.workflowSectionGrouper.getSectionByName(sectionName);
        String json = section == null ? "[]" : new Gson().toJson(section.listWorkflows());
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_dataproviders.json"})
    public void listDataproviders(HttpServletResponse response) throws ISLookUpException, IOException {
        DataproviderWorkflowSection section = this.workflowSectionGrouper.getDataproviderWorkflowSection();
        String json = section == null ? "[]" : new Gson().toJson(section.listWorkflows());
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.json"})
    public void getMetaWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String xml = this.isLookupClient.getSarasvatiMetaWorkflow(id);
        AdvancedMetaWorkflowDescriptor wf = this.isLookupClient.getMetaWorkflow(id);
        wf.setMapContent(this.processGraphGenerator.getMetaWfDescImageMap(id, xml));
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)wf)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.json"})
    public void getAtomicWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String xml = this.profileToSarasvatiConverter.getSarasvatiWorkflow(id).getWorkflowXml();
        AtomicWorkflowDescriptor wf = this.isLookupClient.getAtomicWorkflow(id);
        wf.setMapContent(this.processGraphGenerator.getWfDescImageMap(id, xml));
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)wf)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.img"})
    public void showAtomicWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String xml = this.profileToSarasvatiConverter.getSarasvatiWorkflow(id).getWorkflowXml();
        Set<String> notConfiguredNodes = this.isLookupClient.getNotConfiguredNodes(id);
        BufferedImage image = this.processGraphGenerator.getWfDescImage(id, xml, notConfiguredNodes);
        this.sendImage(response, image);
    }

    private void sendImage(HttpServletResponse response, BufferedImage image) throws IOException {
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "png", (OutputStream)out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/ui/wf.start"})
    public void startWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String procId = this.workflowExecutor.startProcess(id);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)procId)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/metawf.start"})
    public void startMetaWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        this.workflowExecutor.startMetaWorkflow(id);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)id)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_workflow_node.json"})
    public void workflowNode_info(HttpServletResponse response, @RequestParam(value="wf", required=true) String wfId, @RequestParam(value="node", required=true) String nodeName) throws ISLookUpException, IOException {
        NodeInfo info = this.isLookupClient.getNodeInfo(wfId, nodeName);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)info)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_workflow_node.save"})
    public void workflowNode_save(HttpServletResponse response, @RequestParam(value="wf", required=true) String wfId, @RequestParam(value="json", required=true) String json) throws Exception {
        Gson gson = new Gson();
        NodeInfo info = (NodeInfo)gson.fromJson(json, NodeInfo.class);
        log.info((Object)("Updating node " + info.getName() + " of wf " + wfId));
        String xml = this.isLookupClient.getProfile(wfId);
        boolean res = this.isRegistryClient.updateSarasvatiWorkflow(wfId, xml, info);
        for (String metaWfId : this.isLookupClient.listMetaWorflowsForWfId(wfId)) {
            if (this.isLookupClient.isExecutable(metaWfId)) {
                this.isRegistryClient.updateMetaWorkflowStatus(metaWfId, WorkflowsConstants.WorkflowStatus.EXECUTABLE);
                continue;
            }
            this.isRegistryClient.updateMetaWorkflowStatus(metaWfId, WorkflowsConstants.WorkflowStatus.WAIT_USER_SETTINGS);
        }
        IOUtils.copy((Reader)new StringReader(gson.toJson((Object)res)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.img"})
    public void showMetaWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String xml = this.isLookupClient.getSarasvatiMetaWorkflow(id);
        BufferedImage image = this.processGraphGenerator.getMetaWfDescImage(id, xml);
        this.sendImage(response, image);
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.edit"})
    public void scheduleMetaWorkflow(HttpServletResponse response, @RequestParam(value="json", required=true) String json) throws Exception {
        Gson gson = new Gson();
        AdvancedMetaWorkflowDescriptor info = (AdvancedMetaWorkflowDescriptor)gson.fromJson(json, AdvancedMetaWorkflowDescriptor.class);
        log.info((Object)("Updating workflow " + info.getName()));
        String xml = this.isLookupClient.getProfile(info.getWfId());
        boolean res = this.isRegistryClient.updateSarasvatiMetaWorkflow(info.getWfId(), xml, info);
        IOUtils.copy((Reader)new StringReader(gson.toJson((Object)res)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.clone"})
    public void cloneMetaWf(HttpServletResponse response, @RequestParam(value="id", required=true) String id, @RequestParam(value="name", required=true) String name) throws Exception {
        Document doc;
        Gson gson;
        if (name.trim().length() > 0) {
            gson = new Gson();
            String xml = this.isLookupClient.getProfile(id);
            SAXReader reader = new SAXReader();
            doc = reader.read((Reader)new StringReader(xml));
            doc.selectSingleNode("//METAWORKFLOW_NAME").setText(name);
            for (Object o : doc.selectNodes("//WORKFLOW")) {
                Element n = (Element)o;
                String atomWfXml = this.isLookupClient.getProfile(n.valueOf("@id"));
                String newAtomWfId = this.isRegistryClient.registerProfile(atomWfXml);
                n.addAttribute("id", newAtomWfId);
            }
        } else {
            throw new IllegalArgumentException("Name is empty");
        }
        String res = this.isRegistryClient.registerProfile(doc.asXML());
        IOUtils.copy((Reader)new StringReader(gson.toJson((Object)res)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/recentWfs.list"})
    public void recentWfs(HttpServletResponse response) throws IOException {
        ArrayList res = Lists.newArrayList();
        for (String pid : this.graphProcessRegistry.listIdentifiers()) {
            res.add(new ProcessListEntry(pid, this.graphProcessRegistry.findProcess(pid)));
        }
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)res)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/recentWfs.clear"})
    public void clearRecentWfs(HttpServletResponse response, @RequestParam(value="json", required=true) String json) throws IOException {
        for (Object id : (List)new Gson().fromJson(json, List.class)) {
            this.graphProcessRegistry.unregisterProcess(id.toString());
        }
        this.recentWfs(response);
    }

    @RequestMapping(value={"/ui/wf_proc.json"})
    public void getProcessWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        GraphProcess process = this.graphProcessRegistry.findProcess(id);
        String mapContent = process.getState() == ProcessState.Created ? "" : this.processGraphGenerator.getProcessImageMap(id);
        String status = "";
        status = !process.isComplete() ? process.getState().toString().toUpperCase() : ("true".equals(process.getEnv().getAttribute("system:isCompletedSuccessfully")) ? "SUCCESS" : "FAILURE");
        String img = process.getState() == ProcessState.Created ? "file.get?src=notStarted.gif" : "wf_proc.img?id=" + id + "&t=" + DateUtils.now();
        int priority = NumberUtils.toInt((String)process.getEnv().getAttribute("system:priority"), (int)50);
        String name = process.getGraph().getName();
        AtomicWorkflowDescriptor wf = new AtomicWorkflowDescriptor(id, name, priority, status, mapContent, img, true, "auto", "RUNNING");
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)wf)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_proc_node.json"})
    public void getProcessWorkflowNode(HttpServletResponse response, @RequestParam(value="id", required=true) String pid, @RequestParam(value="node", required=true) long nid) throws Exception {
        NodeToken token = this.findNodeToken(pid, nid);
        NodeTokenInfo info = token == null ? new NodeTokenInfo(this.findNodeName(pid, nid)) : new NodeTokenInfo(token);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)info)), (OutputStream)response.getOutputStream());
    }

    private NodeToken findNodeToken(String pid, long nid) {
        GraphProcess process = this.graphProcessRegistry.findProcess(pid);
        if (process != null) {
            for (NodeToken token : process.getNodeTokens()) {
                if (token.getNode().getId() != nid) continue;
                return token;
            }
        }
        return null;
    }

    private String findNodeName(String pid, long nid) {
        GraphProcess process = this.graphProcessRegistry.findProcess(pid);
        if (process != null) {
            for (Node node : process.getGraph().getNodes()) {
                if (node.getId() != nid) continue;
                return node.getName();
            }
        }
        return "-";
    }

    @RequestMapping(value={"/ui/wf_proc.img"})
    public void showProcessWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        BufferedImage image = this.processGraphGenerator.getProcessImage(id);
        this.sendImage(response, image);
    }

    @RequestMapping(value={"/ui/wf_proc.kill"})
    public void killProcessWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        GraphProcess proc = this.graphProcessRegistry.findProcess(id);
        proc.setState(ProcessState.Canceled);
        this.getProcessWorkflow(response, id);
    }

    @RequestMapping(value={"/ui/wf_journal.list"})
    public void listWfJournal(HttpServletResponse response) throws Exception {
        Iterable journal = Iterables.transform((Iterable)this.dnetLogger, (Function)new JournalEntryFunction());
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)Lists.newArrayList((Iterable)journal))), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_journal.range"})
    public void rangeWfJournal(HttpServletResponse response, @RequestParam(value="start", required=true) String start, @RequestParam(value="end", required=true) String end) throws Exception {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTime startDate = formatter.parseDateTime(start);
        DateTime endDate = formatter.parseDateTime(end).plusHours(23).plusMinutes(59).plusSeconds(59);
        Iterator iter = this.dnetLogger.range(startDate.toDate(), endDate.toDate());
        ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)iter, (Function)new JournalEntryFunction()));
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)list)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_journal.find"})
    public void findWfJournalLogs(HttpServletResponse response, @RequestParam(value="id", required=true) String wfId) throws Exception {
        Iterator iter = this.dnetLogger.find("system:profileId", wfId);
        ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)iter, (Function)new JournalEntryFunction()));
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)list)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_journal.get"})
    public void getWfJournalLog(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        final Map map = this.dnetLogger.findOne("system:processId", id);
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort((List)keys);
        List list = Lists.transform((List)keys, (Function)new Function<String, Map<String, String>>(){

            public Map<String, String> apply(String k) {
                HashMap res = Maps.newHashMap();
                res.put("k", k);
                res.put("v", map.get(k));
                return res;
            }
        });
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)list)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.enable"})
    public void enableAtomicWf(HttpServletResponse response, @RequestParam(value="id", required=true) String id, @RequestParam(value="start", required=true) String value) throws Exception {
        this.isRegistryClient.configureWorkflowStart(id, value);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)value)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.priority"})
    public void changeAtomicWfPriority(HttpServletResponse response, @RequestParam(value="id", required=true) String id, @RequestParam(value="value", required=true) int value) throws Exception {
        this.isRegistryClient.changeAtomicWfPriority(id, value);
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)value)), (OutputStream)response.getOutputStream());
    }

    private final class JournalEntryFunction
    implements Function<Map<String, String>, Map<String, String>> {
        private JournalEntryFunction() {
        }

        public Map<String, String> apply(Map<String, String> input) {
            String wfName = input.get("system:profileName");
            if (input.containsKey("dataprovider:name")) {
                wfName = wfName + " (" + input.get("dataprovider:name") + ")";
            }
            HashMap map = Maps.newHashMap();
            map.put("procId", input.get("system:processId"));
            map.put("wfId", input.get("system:profileId"));
            map.put("wfName", wfName);
            map.put("wfFamily", input.get("system:profileFamily"));
            map.put("date", input.get("log:date"));
            map.put("prettyDate", input.get("log:date:pretty"));
            map.put("wfStatus", Boolean.valueOf(input.get("system:isCompletedSuccessfully")) != false ? "SUCCESS" : "FAILURE");
            return map;
        }
    }
}

