package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer;

import javax.swing.Icon;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.GraphToImageMapAdapter;

import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.WorkflowIcon;
import eu.dnetlib.msro.workflows.nodes.WorkflowNode;

public class MetaGraphToImageMapHelper extends GraphToImageMapAdapter {

	@Override
	public String hrefForNode (Node node) {
		if (node instanceof WorkflowNode) {
			return "javascript:getScope('map').getAtomicWorkflow('" + ((WorkflowNode) node).getWorkflowId() + "')";
		} else {
			return "javascript:void(0)";
		}
	}
	
	@Override
	public String hoverForNode (Node node) {
		return "Name: " + node.getName();
	}
	
	@Override
	public Icon iconForNode(Node node) {
		return new WorkflowIcon(node);
	}
}

