package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.util.FontUtil;

import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import eu.dnetlib.msro.workflows.nodes.WorkflowNode;


public class WorkflowIcon extends AbstractIcon {

	private NodeStatus status = NodeStatus.DISABLED;
	
	public WorkflowIcon(final Node node) {
		super(node);
		
		if (node instanceof WorkflowNode) {
			this.status = ((WorkflowNode) node).getStatus();
		}

		redrawImage();
	}
	
	@Override
	public void redrawImage(final Graphics2D gfx) {
		super.resetGfx(gfx);
		
		switch (status) {
		case CONFIGURED:
			gfx.setColor(Color.decode("#336699"));
			break;
		case NOT_CONFIGURED:
			gfx.setColor(Color.decode("#bb0000"));
			break;
		default:
			gfx.setColor(Color.decode("#aabbcc"));
			break;
		}
		
		gfx.fillRoundRect(0, 0, WIDTH - 1, HEIGHT - 1, ROUND_CORNER, ROUND_CORNER);

		gfx.setColor(NodeDrawConfig.NODE_BORDER);
		final BasicStroke stroke = new BasicStroke(2, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 10, getDashes(), 0);
		gfx.setStroke(stroke);
		gfx.drawRoundRect(0, 0, WIDTH - 1, HEIGHT - 1, ROUND_CORNER, ROUND_CORNER);

		gfx.setColor(Color.white);
		final int padding = 6;
		final int startX = padding;
		final int maxWidth = getIconWidth() - (padding << 1);
		FontUtil.setSizedFont(gfx, getLabel(), FONT_SIZE, maxWidth);
		final int strWidth = (int) Math.ceil(gfx.getFontMetrics().getStringBounds(getLabel(), gfx).getWidth());
		final int strHeight = gfx.getFontMetrics().getAscent();
		final int left = startX + ((maxWidth - strWidth) >> 1);
		final int top = ((getIconHeight() + strHeight) >> 1);
		gfx.drawString(getLabel(), left, top);
		
		super.resetGfx(gfx);
	}
}
