package eu.dnetlib.functionality.modular.ui.workflows.objects;

import com.googlecode.sarasvati.GraphProcess;

import eu.dnetlib.msro.workflows.util.ProcessUtils;

public class ProcessListEntry {
	private String procId;
	private String name;
	private String family;
	private String status;
	private String lastActivity;
	
	public ProcessListEntry() {}
	
	public ProcessListEntry(String procId, String name, String family, String status, String lastActivity) {
		this.procId = procId;
		this.name = name;
		this.family = family;
		this.status = status;
		this.lastActivity = lastActivity;
	}

	public ProcessListEntry(final String procId, final GraphProcess process) {
		super();
		this.procId = procId;
		this.name = ProcessUtils.calculateName(process);
		this.family = ProcessUtils.calculateFamily(process);
		this.status = ProcessUtils.calculateStatus(process);
		this.lastActivity = ProcessUtils.calculateLastActivity(process);
	}

	public String getProcId() {
		return procId;
	}

	public void setProcId(String procId) {
		this.procId = procId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getLastActivity() {
		return lastActivity;
	}

	public void setLastActivity(String lastActivity) {
		this.lastActivity = lastActivity;
	}

	public String getFamily() {
		return family;
	}

	public void setFamily(String family) {
		this.family = family;
	}

}
