package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.HashSet;
import java.util.Set;

import com.google.common.collect.Sets;

import eu.dnetlib.msro.workflows.util.WorkflowsConstants.WorkflowStatus;

public class DatasourceWorkflowDescriptor extends AbstractWorkflowDescriptor {

	private String dsId;
	private Set<String> dsProtocols;
	private String dsTypology;
	private Set<MetaWorkflowDescriptor> metaworkflows;
	private Set<String> wfFamilyNames;
	private Set<String> wfStatuses;

	public DatasourceWorkflowDescriptor(final String dsId, final String name, final Set<String> dsProtocols, final String dsTypology,
			final Set<MetaWorkflowDescriptor> metaworkflows) {
		super(dsId, name, "");
		this.dsId = dsId;
		this.dsProtocols = Sets.newHashSet();
		for (String s : dsProtocols) {
			this.dsProtocols.add("@" + s + "@");
		}

		this.dsTypology = "@" + dsTypology + "@";
		this.setMetaworkflows(metaworkflows != null ? metaworkflows : new HashSet<MetaWorkflowDescriptor>());
		this.wfFamilyNames = Sets.newHashSet();
		this.wfStatuses = Sets.newHashSet();

		if (metaworkflows.isEmpty()) {
			setCssClass("wf_missing");
		} else {
			for (MetaWorkflowDescriptor mw : metaworkflows) {
				this.wfFamilyNames.add("@" + mw.getFamilyName() + "@");
				this.wfStatuses.add("@" + mw.getStatusEnum().toString() + "@");
				switch (mw.getStatusEnum()) {
				case ASSIGNED:
				case WAIT_SYS_SETTINGS:
				case WAIT_USER_SETTINGS:
					setCssClass("wf_warning");
					return;
				default:
					break;
				}
			}
		}
		if (this.wfStatuses.isEmpty()) {
			wfStatuses.add(WorkflowStatus.MISSING.toString());
		}
	}

	public DatasourceWorkflowDescriptor(final DatasourceWorkflowDescriptor desc) {
		this(desc.getDsId(), desc.getName(), desc.getDsProtocols(), desc.getDsTypology(), desc.getMetaworkflows());
	}

	public Set<String> getDsProtocols() {
		return dsProtocols;
	}

	public void setDsProtocols(final Set<String> dsProtocols) {
		this.dsProtocols = dsProtocols;
	}

	public String getDsTypology() {
		return dsTypology;
	}

	public void setDsTypology(final String dsTypology) {
		this.dsTypology = dsTypology;
	}

	public String getDsId() {
		return dsId;
	}

	public void setDsId(final String dsId) {
		this.dsId = dsId;
	}

	public Set<MetaWorkflowDescriptor> getMetaworkflows() {
		return metaworkflows;
	}

	public void setMetaworkflows(final Set<MetaWorkflowDescriptor> metaworkflows) {
		this.metaworkflows = metaworkflows;
	}

	public Set<String> getWfStatuses() {
		return wfStatuses;
	}

	public void setWfStatuses(final Set<String> wfStatuses) {
		this.wfStatuses = wfStatuses;
	}

}
