/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.values;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class OaiListSetsValues
extends ValidNodeValuesFetcher {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private SAXReader reader = new SAXReader();
    private HttpClient client = new HttpClient();
    private static final Log log = LogFactory.getLog(OaiListSetsValues.class);

    protected List<ValidNodeValuesFetcher.DnetParamValue> obtainValues(Map<String, String> params) throws Exception {
        if (params.containsKey("baseUrl")) {
            return this.executeListSets(params.get("baseUrl"));
        }
        this.verifyParams(params, new String[]{"dsId", "ifaceId"});
        String baseUrl = this.obtainBaseUrl(params.get("dsId"), params.get("ifaceId"));
        return this.executeListSets(baseUrl);
    }

    private String obtainBaseUrl(String dsId, String ifaceId) throws Exception {
        String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(dsId);
        Document doc = this.reader.read((Reader)new StringReader(profile));
        Node iface = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
        if (!iface.valueOf("./ACCESS_PROTOCOL").equalsIgnoreCase("oai")) {
            log.error((Object)("Invalid protocol for interface " + ifaceId));
            throw new MSROException("Invalid protocol for interface " + ifaceId);
        }
        return iface.valueOf("./BASE_URL");
    }

    private List<ValidNodeValuesFetcher.DnetParamValue> executeListSets(String baseUrl) throws Exception {
        GetMethod method = new GetMethod(baseUrl);
        method.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
        method.setQueryString(new NameValuePair[]{new NameValuePair("verb", "ListSets")});
        int responseCode = this.client.executeMethod((HttpMethod)method);
        if (200 != responseCode) {
            log.error((Object)("Error downloading listSets from baseUrl: " + baseUrl));
            throw new CollectorServiceException("Error " + responseCode + " dowloading ListSets: " + method.getURI());
        }
        Document responseDoc = this.reader.read(method.getResponseBodyAsStream());
        ArrayList list = Lists.newArrayList();
        for (Object o : responseDoc.selectNodes("//*[local-name()='set']")) {
            Node n = (Node)o;
            String setSpec = n.valueOf("./*[local-name()='setSpec']");
            String setName = n.valueOf("./*[local-name()='setName']");
            list.add(new ValidNodeValuesFetcher.DnetParamValue((ValidNodeValuesFetcher)this, setSpec, setName));
        }
        return list;
    }
}

