/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.NodeToken;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class NodeTokenInfo {
    private String name;
    private String start;
    private String end;
    private List<EnvParam> params;

    public NodeTokenInfo(String name) {
        this.name = name;
        this.start = "-";
        this.end = "-";
        this.params = Lists.newArrayList();
    }

    public NodeTokenInfo(NodeToken token) {
        Date start = token.getCreateDate();
        Date end = token.getCompleteDate();
        this.name = token.getNode().getName();
        this.start = start == null ? "-" : start.toString();
        this.end = end == null ? "-" : end.toString();
        HashMap map = Maps.newHashMap();
        for (String name : token.getFullEnv().getAttributeNames()) {
            map.put(name, new EnvParam(name, token.getFullEnv().getAttribute(name)));
        }
        for (String name : token.getEnv().getAttributeNames()) {
            map.put(name, new EnvParam(name, token.getEnv().getAttribute(name)));
        }
        this.params = Lists.newArrayList(map.values());
        Collections.sort(this.params, (Comparator)new Comparator<EnvParam>(){

            @Override
            public int compare(EnvParam o1, EnvParam o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public List<EnvParam> getParams() {
        return this.params;
    }

    public class EnvParam {
        private String name;
        private String value;

        public EnvParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

