/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class OaiIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(OaiIterator.class);
    private Queue<String> queue = new PriorityBlockingQueue<String>();
    private SAXReader reader = new SAXReader();
    private HttpClient client = new HttpClient();
    private String baseUrl;
    private String token;

    public OaiIterator(String baseUrl, String mdFormat, String set) {
        this.baseUrl = baseUrl;
        this.token = set != null && !set.isEmpty() ? this.firstPage(mdFormat, set) : this.firstPage(mdFormat, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.token != null && !this.token.isEmpty()) {
                this.token = this.otherPages(this.token);
            }
            return res;
        }
    }

    @Override
    public void remove() {
    }

    private String firstPage(String mdFormat, String set) {
        String url = this.baseUrl + "?verb=ListRecords&metadataPrefix=" + mdFormat;
        if (set != null && !set.isEmpty()) {
            url = url + "&set=" + set;
        }
        return this.downloadPage(url);
    }

    private String otherPages(String resumptionToken) {
        return this.downloadPage(this.baseUrl + "?verb=ListRecords&resumptionToken=" + resumptionToken);
    }

    private String downloadPage(String url) {
        try {
            log.info((Object)("HTTP GET: " + url));
            GetMethod method = new GetMethod(url);
            int responseCode = this.client.executeMethod((HttpMethod)method);
            if (200 != responseCode) {
                throw new CollectorServiceException("Error " + responseCode + " dowloading url: " + url);
            }
            Document doc = this.reader.read(method.getResponseBodyAsStream());
            for (Object o : doc.selectNodes("//*[local-name()='ListRecords']/*[local-name()='record']")) {
                this.queue.add(((Node)o).asXML());
            }
            return doc.valueOf("//*[local-name()='resumptionToken']");
        }
        catch (Exception e) {
            throw new RuntimeException("Error obtaining records from: " + url, e);
        }
    }
}

