/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.oai.OaiIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;

public class OaiCollectorPlugin
implements CollectorPlugin {
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String mdFormat = (String)interfaceDescriptor.getParams().get(FORMAT_PARAM);
        final String set = (String)interfaceDescriptor.getParams().get(OAI_SET_PARAM);
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new CollectorServiceException("Param 'mdFormat' is null or empty");
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new OaiIterator(baseUrl, mdFormat, set);
            }
        };
    }

    public String getProtocol() {
        return "OAI";
    }
}

