/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugins.ftp.FtpDirectoryWalker;
import eu.dnetlib.data.collector.plugins.ftp.FtpIterable;
import eu.dnetlib.data.collector.plugins.ftp.ItemUtility;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public class FtpFileWalker<T>
extends FtpDirectoryWalker<T> {
    private static final Log log = LogFactory.getLog(FtpFileWalker.class);
    private final BlockingQueue<T> queue;
    public static String IGNORE_PREFIX = ".";
    public static String IGNORE_SUFFIX = "~";
    static IOFileFilter fileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.orFileFilter((IOFileFilter)new SuffixFileFilter("~"), (IOFileFilter)HiddenFileFilter.HIDDEN));

    public FtpFileWalker(BlockingQueue<T> queue, FTPFileFilter filter, int depthLimit, ItemUtility itemParam, String protocol) {
        super(filter, depthLimit, itemParam, protocol);
        this.queue = queue;
    }

    public void doWalk(String source) throws IOException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.enqueue(this.queue, FtpIterable.done);
            throw new IllegalStateException(e);
        }
        FTPFile[] files = this.clientProvider.listFiles(source);
        if (files.length == 1) {
            if (source.contains(files[0].getName())) {
                this.enqueue(this.queue, this.getFileFrom(source));
            } else {
                this.walk(source, this.queue);
            }
        } else if (files.length > 0) {
            this.walk(source, this.queue);
        }
        this.enqueue(this.queue, FtpIterable.done);
    }

    @Override
    protected void handleFile(FTPFile file, int depth, Collection results) throws IOException {
        if (file.getName().endsWith(IGNORE_SUFFIX)) {
            return;
        }
        String myFile = this.readFile(file);
        if (myFile == null) {
            return;
        }
        this.enqueue((BlockingQueue)results, myFile);
    }

    @Override
    protected boolean handleDirectory(String directory, int depth, Collection results) throws IOException {
        String[] tmp = directory.split("/");
        if (tmp.length > 0 && tmp[tmp.length - 1].startsWith(IGNORE_PREFIX)) {
            return false;
        }
        return super.handleDirectory(directory, depth, results);
    }

    private void enqueue(BlockingQueue<T> queue, T element) {
        try {
            queue.put(element);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Hopssss... ", (Throwable)e);
        }
    }

    private String readFile(FTPFile file) throws IOException {
        if (this.getCurrentDirectory() == null) {
            this.clientProvider.completePendingCommand();
            return this.getCurrentDirectory();
        }
        String fileContent = this.getFileFrom(this.getCurrentDirectory() + "/" + file.getName());
        if (fileContent.startsWith("\ufeff")) {
            fileContent = fileContent.substring(1);
        }
        return fileContent;
    }
}

