/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.ftp.FtpIterable;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(FtpCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        HashMap params = interfaceDescriptor.getParams();
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String username = (String)interfaceDescriptor.getParams().get("username");
        String password = (String)interfaceDescriptor.getParams().get("password");
        String filter = (String)interfaceDescriptor.getParams().get("filter");
        boolean isRecursive = Boolean.parseBoolean((String)interfaceDescriptor.getParams().get("recursive"));
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (filter == null || filter.isEmpty()) {
            throw new CollectorServiceException("Param 'filter' is null or empty");
        }
        try {
            return new FtpIterable(interfaceDescriptor);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Ftp collector plugin failed", (Throwable)e);
            return null;
        }
    }

    public String getProtocol() {
        return "ftp";
    }
}

